/*
 * Decompiled with CFR 0.152.
 */
package com.gsl.schematron.support.datetime;

import com.gsl.schematron.support.datetime.XsDateType;
import com.gsl.schematron.support.datetime.XsDuration;
import org.joda.time.DateTime;
import org.joda.time.PeriodType;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;

public class XsGDay
extends XsDateType {
    private static DateTimeFormatter FORMAT = DateTimeFormat.forPattern("---dd");

    public static XsGDay parse(String string) {
        return new XsGDay(FORMAT.parseDateTime(string));
    }

    public XsGDay(DateTime dt) {
        super(dt);
    }

    @Override
    public XsDateType add(XsDuration duration) {
        return new XsGDay(this.asDateTime().plus(duration.asPeriod()));
    }

    @Override
    protected XsDateType cast(XsDateType date) {
        if (date.getClass() != this.getClass()) {
            date = new XsGDay(date.asDateTime());
        }
        return date;
    }

    @Override
    protected PeriodType getPeriodType() {
        return PeriodType.days();
    }

    @Override
    protected int ranking() {
        return 2;
    }

    public String toString() {
        return FORMAT.print(this.asDateTime());
    }

    @Override
    public XsDateType convertDateToMyPrecision(XsDateType date2) {
        throw new UnsupportedOperationException("implement me!");
    }

    @Override
    protected boolean hasDay() {
        return true;
    }

    @Override
    protected boolean hasMonth() {
        return false;
    }

    @Override
    protected boolean hasTime() {
        return false;
    }

    @Override
    protected boolean hasYear() {
        return false;
    }

    @Override
    public String toXMLSchemaString() {
        throw new UnsupportedOperationException("implement me!");
    }
}

