/*
 * Decompiled with CFR 0.152.
 */
package com.gsl.schematron.support.nodes;

import com.gsl.schematron.support.nodes.AbstractNode;
import com.gsl.schematron.support.nodes.AttributeNode;
import com.gsl.schematron.support.nodes.Node;
import com.gsl.schematron.support.nodes.NodeList;
import com.gsl.schematron.support.nodes.TextNode;
import java.util.Iterator;
import xmldoc.Attribute;

public class ElementNode
extends AbstractNode {
    public static final NodeList<ElementNode> EMPTY_ELEMENT_LIST = new NodeList();
    private String prefix = "";
    private final String localName;
    private final NodeList<Node> content = new NodeList();
    private final NodeList<AttributeNode> attributes = new NodeList();

    public ElementNode(String prefix, String localName) {
        this.prefix = prefix;
        this.localName = localName;
    }

    public ElementNode(String prefix, String localName, String text, Attribute[] attributes) {
        this(prefix, localName);
        if (text != null) {
            this.content.add(new TextNode(text));
        }
        for (Attribute attribute : attributes) {
            this.attributes.add(new AttributeNode(attribute.getLocalName(), attribute.getValue()));
        }
    }

    public String toString() {
        return "ElementNode [prefix='" + this.prefix + "', localName='" + this.localName + "', attributes=" + this.attributes + "]";
    }

    public ElementNode(String localName, String value, Attribute[] attributes) {
        this("", localName, value, attributes);
    }

    public ElementNode(String localName) {
        this("", localName);
    }

    @Override
    public String getAttributeValue(String localName) {
        NodeList<AttributeNode> attrs = this.getAttributes(localName);
        if (!attrs.isEmpty()) {
            return ((AttributeNode)attrs.get(0)).getValue();
        }
        return null;
    }

    @Override
    public String stringValue() {
        StringBuilder result = new StringBuilder();
        for (Node n : this.content) {
            if (!(n instanceof TextNode) && !(n instanceof ElementNode)) continue;
            result.append(n.stringValue());
        }
        return result.toString();
    }

    public String getPrefix() {
        return this.prefix;
    }

    @Override
    public String getLocalName() {
        return this.localName;
    }

    @Override
    public NodeList<ElementNode> precedingSibling(String prefix, String localName) {
        return this.parent().precedingSibling(this, prefix, localName);
    }

    @Override
    public NodeList<ElementNode> precedingSibling(Node referenceElement, String prefix, String localName) {
        Node n;
        NodeList<ElementNode> siblings = new NodeList<ElementNode>();
        assert (this.content.contains(referenceElement)) : "Trying to find preceding sibling of a reference element which is not in the content of this node";
        Iterator i$ = this.content.iterator();
        while (i$.hasNext() && (n = (Node)i$.next()) != referenceElement) {
            if (!(n instanceof ElementNode)) continue;
            ElementNode e = (ElementNode)n;
            if (!e.prefix.equals(prefix) || !e.localName.equals(localName)) continue;
            siblings.add(e);
        }
        return siblings;
    }

    public NodeList<TextNode> getText() {
        throw new UnsupportedOperationException("implement me!");
    }

    @Override
    public NodeList<TextNode> text() {
        NodeList<TextNode> textNodes = new NodeList<TextNode>();
        for (Node n : this.content) {
            if (!(n instanceof TextNode)) continue;
            textNodes.add((TextNode)n);
        }
        return textNodes;
    }

    @Override
    public NodeList<AttributeNode> getAttributes(String localName) {
        NodeList<AttributeNode> result = new NodeList<AttributeNode>();
        for (AttributeNode attr : this.attributes) {
            if (!attr.getLocalName().equals(localName)) continue;
            result.add(attr);
        }
        return result;
    }

    public void addText(String text) {
        this.content.add(new TextNode(this, text));
    }

    @Override
    public void addElement(ElementNode child) {
        this.content.add(child);
        child.setParent(this);
    }

    @Override
    public NodeList<ElementNode> element(String prefix, String localName) {
        NodeList<ElementNode> result = new NodeList<ElementNode>();
        for (Node n : this.content) {
            if (!(n instanceof ElementNode)) continue;
            ElementNode e = (ElementNode)n;
            if (!prefix.equals(e.prefix) || !localName.equals(e.localName)) continue;
            result.add(e);
        }
        return result;
    }

    @Override
    public NodeList<ElementNode> elements() {
        NodeList<ElementNode> result = new NodeList<ElementNode>();
        for (Node n : this.content) {
            if (!(n instanceof ElementNode)) continue;
            ElementNode e = (ElementNode)n;
            result.add(e);
        }
        return result;
    }
}

