/*
 * Decompiled with CFR 0.152.
 */
package com.gsl.schematron.support.nodes;

import com.gsl.schematron.support.Predicate;
import com.gsl.schematron.support.nodes.AttributeNode;
import com.gsl.schematron.support.nodes.ElementNode;
import com.gsl.schematron.support.nodes.Node;
import com.gsl.schematron.support.nodes.TextNode;
import java.util.ArrayList;
import java.util.Iterator;

public class NodeList<NodeType extends Node>
extends ArrayList<NodeType> {
    private static final long serialVersionUID = 8937552359843403194L;

    public NodeList() {
    }

    public NodeList(int size) {
        super(size);
    }

    public NodeList(NodeList<NodeType> nodeList) {
        this.addAll(nodeList);
    }

    public NodeList<NodeType> precedingSiblingAxis(NodeType node) {
        Node nodeInList;
        NodeList<NodeType> result = new NodeList<NodeType>();
        Iterator i$ = this.iterator();
        while (i$.hasNext() && (nodeInList = (Node)i$.next()) != node) {
            result.add(nodeInList);
        }
        return result;
    }

    public NodeType last() {
        if (this.size() > 0) {
            return (NodeType)((Node)this.get(this.size() - 1));
        }
        return null;
    }

    public NodeList<ElementNode> children(String string, String string2) {
        throw new UnsupportedOperationException("implement me!");
    }

    public NodeList<TextNode> text() {
        NodeList<TextNode> textNodes = new NodeList<TextNode>();
        for (Node n : this) {
            textNodes.addAll(n.text());
        }
        return textNodes;
    }

    public NodeList<ElementNode> element(String prefix, String localName) {
        NodeList<ElementNode> elementNodes = new NodeList<ElementNode>();
        for (Node n : this) {
            elementNodes.addAll(n.element(prefix, localName));
        }
        return elementNodes;
    }

    public NodeList<ElementNode> elements() {
        NodeList<ElementNode> elementNodes = new NodeList<ElementNode>();
        for (Node n : this) {
            elementNodes.addAll(n.elements());
        }
        return elementNodes;
    }

    public NodeList<NodeType> applyPredicate(Predicate<Node> predicate) {
        NodeList<NodeType> results = new NodeList<NodeType>();
        int position = 0;
        for (Node n : this) {
            if (!predicate.checkPredicate(n, ++position)) continue;
            results.add(n);
        }
        return results;
    }

    public NodeList<AttributeNode> getAttributes(String localName) {
        NodeList<AttributeNode> result = new NodeList<AttributeNode>();
        for (Node node : this) {
            result.addAll(node.getAttributes(localName));
        }
        return result;
    }
}

