/*
 * Decompiled with CFR 0.152.
 */
package com.gsl.schematron.support.util;

import com.gsl.docValidator.CurrentDate;
import com.gsl.schematron.support.datetime.DateTimeTimezone;
import com.gsl.schematron.support.datetime.XsDateTime;
import com.gsl.schematron.support.datetime.XsDateType;
import com.gsl.schematron.support.datetime.XsDuration;
import com.gsl.schematron.support.nodes.Node;
import com.gsl.schematron.support.nodes.NodeList;
import com.gsl.schematron.support.util.ValueUtil;
import java.util.GregorianCalendar;
import java.util.List;
import org.joda.time.DateMidnight;
import org.joda.time.DateTime;
import org.joda.time.base.BaseDateTime;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;

public class DateUtil {
    private static DateTimeFormatter dateFormatter = DateTimeFormat.forPattern("yyyy-MM-dd");

    public static String difference(String dateStr1, DateTime date2) {
        XsDateType date1 = XsDateType.parseDate(dateStr1);
        if (date1 == null) {
            return "";
        }
        XsDuration duration = date1.difference(new XsDateTime(date2));
        return duration.toString();
    }

    public static String difference(String dateStr1, DateMidnight date2) {
        return DateUtil.difference(dateStr1, date2.toDateTime());
    }

    public static String difference(List<Node> dateList1, List<Node> dateList2) {
        XsDateType date1 = XsDateType.parseDate(ValueUtil.asString(dateList1));
        if (date1 == null) {
            return "";
        }
        XsDateType date2 = XsDateType.parseDate(ValueUtil.asString(dateList2));
        XsDuration duration = date1.difference(date2);
        return duration.toString();
    }

    public static String difference(List<Node> dateList1, String date2) {
        return DateUtil.difference(ValueUtil.asString(dateList1), date2);
    }

    public static String difference(String date1, List<Node> dateList2) {
        return DateUtil.difference(date1, ValueUtil.asString(dateList2));
    }

    public static String difference(String dateStr1, String dateStr2) {
        try {
            XsDateType date1 = XsDateType.parseDate(dateStr1);
            XsDateType date2 = XsDateType.parseDate(dateStr2);
            if (date1.isMorePreciseThan(date2)) {
                date1 = date2.convertDateToMyPrecision(date1);
            } else if (date2.isMorePreciseThan(date1)) {
                date2 = date1.convertDateToMyPrecision(date2);
            }
            try {
                XsDuration duration = date1.difference(date2);
                return duration.toString();
            }
            catch (IllegalArgumentException e) {
                return "";
            }
        }
        catch (IllegalArgumentException e) {
            return "";
        }
    }

    public static long differenceInSeconds(String dateStr1, String dateStr2) {
        XsDateType date2;
        XsDateType date1 = XsDateType.parseDate(dateStr1);
        if (date1.isMorePreciseThan(date2 = XsDateType.parseDate(dateStr2))) {
            date1 = date2.convertDateToMyPrecision(date1);
        } else if (date2.isMorePreciseThan(date1)) {
            date2 = date1.convertDateToMyPrecision(date2);
        }
        return date1.differenceInSeconds(date2);
    }

    public static String add(NodeList<? extends Node> dateList, String durationStr) {
        return DateUtil.add(ValueUtil.asString(dateList), durationStr);
    }

    public static String add(String dateStr, String durationStr) {
        XsDateType date = XsDateType.parseDate(dateStr);
        if (date == null) {
            return null;
        }
        XsDuration duration = XsDuration.parseDuration(durationStr);
        if (duration == null) {
            return "";
        }
        XsDateType result = date.add(duration);
        return result.toString();
    }

    public static String add(BaseDateTime dateTime, String durationStr) {
        XsDateType date = XsDateType.fromBaseDateTime(dateTime);
        XsDuration duration = XsDuration.parseDuration(durationStr);
        if (duration == null) {
            return "";
        }
        XsDateType result = date.add(duration);
        return result.toString();
    }

    public static String add(DateMidnight dateTime, String durationStr) {
        XsDateTime date = new XsDateTime(dateTime.toDateTime());
        XsDuration duration = XsDuration.parseDuration(durationStr);
        if (duration == null) {
            return null;
        }
        XsDateType result = ((XsDateType)date).add(duration);
        return result.asDateTime().toString(dateFormatter);
    }

    public static String date() {
        return DateUtil.fastDate().toString(dateFormatter);
    }

    public static String date(String dateTime) {
        try {
            DateTimeTimezone dtt = new DateTimeTimezone(dateTime);
            if (!dtt.hasDatePart()) {
                throw new IllegalArgumentException("'" + dateTime + "' is not a valid date or date/time");
            }
            if (dtt.hasTimezonePart()) {
                return dtt.datePart.toString() + dtt.timezonePart.toString();
            }
            return dtt.datePart;
        }
        catch (IllegalArgumentException e) {
            return "";
        }
    }

    public static double seconds(String dateOrDuration) {
        double result = Double.NaN;
        try {
            if (dateOrDuration.startsWith("P") || dateOrDuration.startsWith("-P")) {
                XsDuration duration = XsDuration.parseDuration(dateOrDuration);
                result = duration.toSeconds();
            } else {
                long longResult = DateUtil.differenceInSeconds("1970-01-01T00:00:00Z", dateOrDuration);
                result = longResult;
            }
        }
        catch (Throwable t) {
            // empty catch block
        }
        return result;
    }

    public static double seconds(NodeList<Node> nodes) {
        return DateUtil.seconds(ValueUtil.asString(nodes));
    }

    public static DateMidnight fastDate() {
        return new DateTime(CurrentDate.getCurrentDate().getTime()).withTime(0, 0, 0, 0).toDateMidnight();
    }

    public static DateTime fastDate(DateTime dt) {
        return dt;
    }

    public static DateMidnight fastDate(String dateStr) {
        try {
            XsDateType date = XsDateType.parseDate(dateStr);
            return date.asDateTime().toDateMidnight();
        }
        catch (IllegalArgumentException e) {
            return null;
        }
    }

    public static DateMidnight fastDate(List<Node> dateList) {
        return DateUtil.fastDate(ValueUtil.asString(dateList));
    }

    public static double dayInMonth(String dateStr) {
        Double result = Double.NaN;
        try {
            XsDateType date = XsDateType.parseDate(dateStr);
            DateTime dateTime = date.asDateTime();
            result = dateTime.getDayOfMonth();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return result;
    }

    public static double dayInMonth(NodeList<Node> nodes) {
        return DateUtil.dayInMonth(ValueUtil.asString(nodes));
    }

    public static double dayInYear(String dateStr) {
        Double result = Double.NaN;
        try {
            XsDateType date = XsDateType.parseDate(dateStr);
            DateTime dateTime = date.asDateTime();
            result = dateTime.getDayOfYear();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return result;
    }

    public static boolean leapYear(String dateStr) {
        GregorianCalendar cal = new GregorianCalendar();
        return cal.isLeapYear((int)DateUtil.year(dateStr));
    }

    public static double monthInYear(String dateStr) {
        Double result = Double.NaN;
        try {
            XsDateType date = XsDateType.parseDate(dateStr);
            DateTime dateTime = date.asDateTime();
            result = dateTime.getMonthOfYear();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return result;
    }

    public static double monthInYear(NodeList<Node> nodes) {
        return DateUtil.monthInYear(ValueUtil.asString(nodes));
    }

    public static double year(String dateStr) {
        double result = Double.NaN;
        if (dateStr.length() >= 4) {
            try {
                result = Integer.parseInt(dateStr.substring(0, 4));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return result;
    }

    public static double year() {
        return DateUtil.fastDate().getYear();
    }

    public static boolean lte(BaseDateTime time1, BaseDateTime time2) {
        if (time1 != null && time2 != null) {
            return time1.compareTo(time2) <= 0;
        }
        return false;
    }

    public static boolean lt(BaseDateTime time1, BaseDateTime time2) {
        if (time1 != null && time2 != null) {
            return time1.compareTo(time2) < 0;
        }
        return false;
    }
}

