/*
 * Decompiled with CFR 0.152.
 */
package com.gsl.schematron.support.util;

import com.gsl.schematron.support.nodes.Node;
import com.gsl.schematron.support.util.ValueUtil;
import com.gsl.schematron.support.util.ops.ADD;
import java.util.Collections;
import java.util.List;

public class NumberUtil {
    public static double sum(List<? extends Node> nodes) {
        double result = 0.0;
        for (Node node : nodes) {
            double value = ValueUtil.asNumber(node);
            result = ADD.instance().op(result, value);
        }
        return result;
    }

    public static boolean equals(double lhs, double rhs) {
        return lhs == rhs;
    }

    public static double sum(Node node) {
        return ValueUtil.asNumber(node);
    }

    public static double minus(double num) {
        return -num;
    }

    public static double abs(double num) {
        return Math.abs(num);
    }

    public static double abs(String s) {
        return NumberUtil.abs(ValueUtil.asNumber(s));
    }

    public static double max(List<Double> numbers) {
        return Collections.max(numbers);
    }

    public static double min(List<Double> numbers) {
        return Collections.min(numbers);
    }

    public static double floor(double num) {
        return Math.floor(num);
    }

    public static double round(double num) {
        return Double.isNaN(num) ? Double.NaN : (double)Math.round(num);
    }
}

