/*
 * Decompiled with CFR 0.152.
 */
package com.gsl.schematron.support.util;

import com.gsl.schematron.support.nodes.Node;
import com.gsl.schematron.support.util.ValueUtil;
import java.util.List;

public class StringUtil {
    public static boolean contains(String s1, String s2) {
        boolean result = false;
        if (s1 != null && s2 != null) {
            result = s1.indexOf(s2) >= 0;
        }
        return result;
    }

    public static String before(String s1, String s2) {
        int i = s1.indexOf(s2);
        if (i < 0) {
            return "";
        }
        return s1.substring(0, i);
    }

    public static String after(String s1, String s2) {
        int i = s1.indexOf(s2);
        if (i < 0) {
            return "";
        }
        return s1.substring(i + s2.length());
    }

    public static String substring(String s, int start, int length) {
        int adjustedStart = start - 1;
        int end = adjustedStart + length;
        if (end >= s.length()) {
            end = s.length();
        }
        if (adjustedStart < 0) {
            adjustedStart = 0;
        }
        if (end < 0) {
            end = 0;
        }
        if (adjustedStart >= s.length()) {
            return "";
        }
        return s.substring(adjustedStart, end);
    }

    public static String substring(String string, double start, double length) {
        return StringUtil.substring(string, (int)Math.round(start), (int)Math.round(length));
    }

    public static String substring(String s, int start) {
        int adjustedStart = start - 1;
        if (adjustedStart < 0) {
            adjustedStart = 0;
        }
        if (adjustedStart >= s.length()) {
            return "";
        }
        return s.substring(adjustedStart);
    }

    public static String translate(String input, String matches, String replacements) {
        char[] inputChars;
        StringBuilder result = new StringBuilder(input.length());
        char[] matchChars = matches.toCharArray();
        char[] replacementChars = replacements.toCharArray();
        for (char c : inputChars = input.toCharArray()) {
            boolean replace = true;
            char replacementChar = c;
            for (int i = 0; i < matchChars.length; ++i) {
                char m = matchChars[i];
                if (c != m) continue;
                if (i >= replacementChars.length) {
                    replace = false;
                    break;
                }
                replacementChar = replacementChars[i];
                break;
            }
            if (!replace) continue;
            result.append(replacementChar);
        }
        return result.toString();
    }

    public static String normalizeSpace(String input) {
        return input.trim().replaceAll("\\s+", " ");
    }

    public static String normalizeSpace(List<? extends Node> nodeSet) {
        return StringUtil.normalizeSpace(ValueUtil.asString(nodeSet));
    }
}

