/*
 * Decompiled with CFR 0.152.
 */
package com.gsl.schematron.support.util;

import com.gsl.schematron.support.nodes.Node;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.List;

public final class ValueUtil {
    private static final NumberFormat INTEGER_FORMATTER = new DecimalFormat("#");

    public static String asString(Object obj) {
        return String.valueOf(obj);
    }

    public static String asString(Node node) {
        return node.stringValue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String asString(double d) {
        if ((double)((long)d) == d) {
            NumberFormat numberFormat = INTEGER_FORMATTER;
            synchronized (numberFormat) {
                return INTEGER_FORMATTER.format(d);
            }
        }
        return Double.toString(d);
    }

    public static String asString(List<? extends Node> list) {
        String result = "";
        if (list.size() > 0) {
            result = ValueUtil.asString(list.get(0));
        }
        return result;
    }

    public static double asNumber(List<? extends Node> list) {
        return ValueUtil.asNumber(ValueUtil.asString(list));
    }

    public static boolean asBoolean(List<? extends Node> list) {
        return !list.isEmpty();
    }

    public static boolean asBoolean(String s) {
        return s != null && s.length() > 0;
    }

    public static boolean asBoolean(double number) {
        return number != 0.0 && !Double.isNaN(number);
    }

    public static String asString(long i) {
        return Long.toString(i);
    }

    public static double asNumber(String numString) {
        double result = Double.NaN;
        try {
            if (numString != null) {
                result = Double.parseDouble(numString.trim());
            }
        }
        catch (NumberFormatException e) {
            result = Double.NaN;
        }
        return result;
    }

    public static double asNumber(Node node) {
        return ValueUtil.asNumber(ValueUtil.asString(node));
    }

    public static int asInteger(double d) {
        return (int)d;
    }

    public static int asInteger(boolean b) {
        return b ? 1 : 0;
    }

    public static double asNumber(long i) {
        return i;
    }

    public static double asNumber(boolean b) {
        return b ? 1.0 : 0.0;
    }
}

