/*
 * Decompiled with CFR 0.152.
 */
package com.gsl.schematron.support.util.ops;

import com.gsl.schematron.support.util.ValueUtil;
import com.gsl.schematron.support.util.ops.AbstractBinaryArithmeticOp;

public class DIVIDE
extends AbstractBinaryArithmeticOp {
    private static final DIVIDE instance = new DIVIDE();

    public static DIVIDE instance() {
        return instance;
    }

    @Override
    public double op(double lhs, double rhs) {
        double result = Double.NaN;
        if (!Double.isNaN(lhs) && !Double.isNaN(rhs)) {
            try {
                result = lhs / rhs;
            }
            catch (ArithmeticException e) {
                result = Double.NaN;
            }
        }
        return result;
    }

    @Override
    public double op(long lhs, long rhs) {
        return this.op(ValueUtil.asNumber(lhs), ValueUtil.asNumber(rhs));
    }
}

