/*
 * Decompiled with CFR 0.152.
 */
package com.gsl.schematron.support.util.ops;

import com.gsl.schematron.support.util.ValueUtil;
import com.gsl.schematron.support.util.ops.AbstractBinaryArithmeticOp;

public class MULTIPLY
extends AbstractBinaryArithmeticOp {
    private static final MULTIPLY instance = new MULTIPLY();

    public static MULTIPLY instance() {
        return instance;
    }

    @Override
    public double op(double lhs, double rhs) {
        double result = Double.NaN;
        if (!Double.isNaN(lhs) && !Double.isNaN(rhs)) {
            result = lhs * rhs;
            if (result == 0.0) {
                result = 0.0;
            }
            return result;
        }
        return result;
    }

    @Override
    public double op(long lhs, long rhs) {
        return ValueUtil.asNumber(lhs * rhs);
    }
}

