/*
 * Decompiled with CFR 0.152.
 */
package com.gsl.schematron.transformer;

import com.gsl.schematron.transformer.def.ElementBindingDef;
import com.gsl.schematron.transformer.def.ElementReferenceDef;
import com.gsl.schematron.transformer.def.InvocationPointDef;
import com.gsl.xs.XLocator;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;

public class BindingContext {
    private XLocator contextXLocator;
    private InvocationPointDef invocationPoint = null;
    private final Set<String> applicableNamespaces = new HashSet<String>();
    private boolean invokesAtContext;
    private final Set<String> relativeLocs = new LinkedHashSet<String>();
    private ElementBindingDef contextNodeBinding = null;
    private final List<ElementBindingDef> elementBindings = new ArrayList<ElementBindingDef>();
    private ElementReferenceDef chainPoint = null;
    private final Set<String> alreadyBound = new HashSet<String>();

    public BindingContext(XLocator contextXLoc) {
        this.contextXLocator = contextXLoc;
    }

    public XLocator getContextXLocator() {
        return this.contextXLocator;
    }

    public void setContextXLocator(XLocator contextXLocator) {
        this.contextXLocator = contextXLocator;
    }

    public Set<String> getRelativeLocs() {
        return this.relativeLocs;
    }

    public void addRelativeLoc(String relativeLoc) {
        this.relativeLocs.add(relativeLoc);
    }

    public InvocationPointDef getInvocationPoint() {
        return this.invocationPoint;
    }

    public void setInvocationPoint(InvocationPointDef invocationPoint) {
        this.invocationPoint = invocationPoint;
        this.addApplicableNamespace(invocationPoint.getNamespace());
    }

    public Set<String> getApplicableNamespaces() {
        return this.applicableNamespaces;
    }

    private void addApplicableNamespace(String namespace) {
        this.applicableNamespaces.add(namespace);
    }

    public boolean isInvokesAtContext() {
        return this.invokesAtContext;
    }

    public void setInvokesAtContext(boolean invokesAtContext) {
        this.invokesAtContext = invokesAtContext;
    }

    public ElementBindingDef getContextElementBinding() {
        return this.contextNodeBinding;
    }

    public void setContextElementBinding(ElementBindingDef contextNodeBinding) {
        this.contextNodeBinding = contextNodeBinding;
    }

    public List<ElementBindingDef> getElementBindings() {
        return this.elementBindings;
    }

    public void addElementBinding(ElementBindingDef elementBinding) {
        this.elementBindings.add(elementBinding);
        this.addApplicableNamespace(elementBinding.getNamespace());
    }

    public ElementReferenceDef getChainPoint() {
        return this.chainPoint;
    }

    public void setChainPoint(ElementReferenceDef chainPoint) {
        this.chainPoint = chainPoint;
    }

    public void addBoundName(String name) {
        this.alreadyBound.add(name);
    }

    public boolean isAlreadyBound(String name) {
        return this.alreadyBound.contains(name);
    }
}

