/*
 * Decompiled with CFR 0.152.
 */
package com.gsl.schematron.transformer;

import com.gsl.schematron.transformer.BindingContext;
import com.gsl.schematron.transformer.CompilerProblem;
import com.gsl.schematron.transformer.DefinitionContext;
import com.gsl.schematron.transformer.RelativeLocators;
import com.gsl.schematron.transformer.SchemaManager;
import com.gsl.schematron.transformer.SchematronTransformerUtil;
import com.gsl.schematron.transformer.def.AssertDef;
import com.gsl.schematron.transformer.def.ElementBindingDef;
import com.gsl.schematron.transformer.def.ElementBindingUseDef;
import com.gsl.schematron.transformer.def.ElementReferenceDef;
import com.gsl.schematron.transformer.def.InvocationPointDef;
import com.gsl.schematron.transformer.def.RuleClassDef;
import com.gsl.schematron.transformer.def.RuleDef;
import com.gsl.xs.SchemaModel;
import com.gsl.xs.SchemaModelPathAvailability;
import com.gsl.xs.SchemaModelPathRelationship;
import com.gsl.xs.XLocator;
import com.gsl.xslt2java.LocationPathDescriptor;
import com.gsl.xslt2java.LocationPathUseHint;
import com.gsl.xslt2java.LocationPathUseType;
import com.gsl.xslt2java.expression.Expression;
import com.gsl.xslt2java.statement.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class BindingGenerator {
    private final boolean debug;
    private final DefinitionContext context;
    private final RuleClassDef ruleClassDef;
    private final XLocator contextXLoc;
    private SchemaModel schemaModel;
    private boolean hasContextPath;
    private boolean hasContextElementRef;
    private Map<XLocator, ReferenceDescriptor> referenceDescriptors;
    private XLocator invocationPointXLoc;
    private XLocator chainPointXLoc;
    private final BindingContext bindingContext;
    private final List<LocationPathUseHint> contextNodeUseHints = new ArrayList<LocationPathUseHint>();

    public static BindingContext generateBindings(DefinitionContext context, RuleClassDef ruleClassDef, XLocator contextXLoc) {
        BindingGenerator generator = new BindingGenerator(context, ruleClassDef, contextXLoc);
        generator.init();
        generator.createPathDescriptors();
        generator.obtainSchemaModel();
        generator.generateInvocationPoint();
        generator.generateValueBindings();
        generator.generateChaining();
        return generator.getBindingContext();
    }

    private BindingContext getBindingContext() {
        return this.bindingContext;
    }

    private BindingGenerator(DefinitionContext context, RuleClassDef ruleClassDef, XLocator contextXLoc) {
        this.debug = context.getParams().isDebugEnabled();
        this.bindingContext = new BindingContext(contextXLoc);
        this.context = context;
        this.ruleClassDef = ruleClassDef;
        this.contextXLoc = contextXLoc;
    }

    private void init() {
        if (this.debug) {
            System.out.println();
        }
        this.referenceDescriptors = new HashMap<XLocator, ReferenceDescriptor>();
        this.invocationPointXLoc = this.contextXLoc;
    }

    private void createPathDescriptors() {
        for (RuleDef ruleDef : this.ruleClassDef.getRuleDefs()) {
            for (AssertDef assertDef : ruleDef.getAssertDefs()) {
                if (this.debug) {
                    System.out.println("context:" + this.contextXLoc);
                }
                if (this.debug) {
                    System.out.println("assert: " + assertDef.getTest());
                }
                Expression expression = assertDef.getExpression();
                for (LocationPathDescriptor descriptor : expression.requiredLocationPathDescriptors()) {
                    if (!this.addLocationPathDescriptor(descriptor)) continue;
                    this.hasContextElementRef = true;
                    this.contextNodeUseHints.addAll(descriptor.getUseHints());
                }
                for (Statement statement : expression.getSupportingStatements()) {
                    for (LocationPathDescriptor descriptor : statement.requiredLocationPathDescriptors()) {
                        this.hasContextElementRef |= this.addLocationPathDescriptor(descriptor);
                    }
                }
            }
        }
        RelativeLocators relativeLocators = this.context.getTransformer().getRelativeLocators();
        if (relativeLocators != null && !relativeLocators.isEmpty()) {
            HashMap<String, Integer> names = new HashMap<String, Integer>();
            Set<XLocator> roots = relativeLocators.getRoots();
            for (XLocator rlocRoot : roots) {
                if (!rlocRoot.isSubPathOf(this.contextXLoc)) continue;
                int sizeDiff = this.contextXLoc.size() - rlocRoot.size();
                for (XLocator rlocPath : relativeLocators.getXPaths(rlocRoot)) {
                    String raisedPath = rlocPath.raiseBy(sizeDiff).toString();
                    String propertyName = SchematronTransformerUtil.toUniqueName(SchematronTransformerUtil.lowerFirstChar(rlocPath.getStep(-1).getName()), names);
                    this.bindingContext.addRelativeLoc(propertyName);
                    LocationPathDescriptor descriptor = new LocationPathDescriptor(raisedPath, propertyName, LocationPathUseType.Value);
                    this.addLocationPathDescriptor(descriptor);
                }
            }
        }
    }

    private void obtainSchemaModel() {
        XLocator path = this.contextXLoc;
        for (ReferenceDescriptor descriptor : this.referenceDescriptors.values()) {
            if (descriptor.absoluteXLoc.uniqueNamespaceCount() <= path.uniqueNamespaceCount()) continue;
            path = descriptor.absoluteXLoc;
        }
        SchemaManager schemaManager = this.context.getTransformer().getContext().getSchemaManager();
        this.schemaModel = schemaManager.getSchemaModel(this.context.getSchemaInfoDef().getNamespacePrefixMapper(), path);
        boolean bl = this.hasContextPath = this.schemaModel.findPathDescriptor(this.contextXLoc) != null;
        if (!this.hasContextPath) {
            this.ruleClassDef.raiseProblem(CompilerProblem.Category.WARNING, "could not resolve context xpath '" + this.contextXLoc + "' against schema");
        }
    }

    private void generateInvocationPoint() {
        for (ReferenceDescriptor referenceDescriptor : this.referenceDescriptors.values()) {
            SchemaModelPathAvailability availability;
            if (this.schemaModel.findPathDescriptor(referenceDescriptor.absoluteXLoc) == null) {
                this.ruleClassDef.raiseProblem(CompilerProblem.Category.WARNING, "could not resolve xpath '" + referenceDescriptor.absoluteXLoc + "' against schema");
                continue;
            }
            if (!this.hasContextPath || referenceDescriptor.referenceXLoc == XLocator.DOT) continue;
            SchemaModelPathRelationship relationship = this.schemaModel.findPathRelationshipToContext(this.contextXLoc, referenceDescriptor.referenceXLoc);
            referenceDescriptor.availability = availability = relationship.getAvailability();
            if (this.debug) {
                System.out.println(availability.toString().toLowerCase().replace('_', ' ') + ": " + referenceDescriptor.referenceXLoc);
            }
            switch (availability) {
                case FORWARD_OF_REPEATING: {
                    XLocator repeatingPointXLoc = relationship.getPathDescriptor().getPath();
                    XLocator loc1 = this.invocationPointXLoc.commonRootWith(repeatingPointXLoc.subPath(-1));
                    XLocator loc2 = this.invocationPointXLoc.commonRootWith(referenceDescriptor.absoluteXLoc);
                    this.invocationPointXLoc = loc1.size() < loc2.size() ? loc1 : loc2;
                    if (this.chainPointXLoc != null) break;
                    this.chainPointXLoc = this.findInnermostRepeatPoint(this.contextXLoc);
                    break;
                }
                case FORWARD_OF_NON_REPEATING: {
                    this.invocationPointXLoc = this.invocationPointXLoc.commonRootWith(referenceDescriptor.absoluteXLoc);
                }
            }
        }
        if (this.debug) {
            System.out.println("invocation point: " + this.invocationPointXLoc);
        }
        InvocationPointDef invocationPoint = new InvocationPointDef();
        invocationPoint.setXLocator(this.invocationPointXLoc);
        this.bindingContext.setInvocationPoint(invocationPoint);
        this.bindingContext.setInvokesAtContext(this.invocationPointXLoc == this.contextXLoc);
    }

    private XLocator findInnermostRepeatPoint(XLocator xLoc) {
        while (!this.schemaModel.findPathDescriptor(xLoc).isRepeating()) {
            xLoc = xLoc.subPath(-1);
        }
        return xLoc;
    }

    private void generateValueBindings() {
        if (this.hasContextElementRef) {
            ElementBindingDef elementBinding = new ElementBindingDef();
            elementBinding.setName("contextNode");
            elementBinding.setXLocator(this.contextXLoc);
            this.bindingContext.setContextElementBinding(elementBinding);
        }
        HashMap<String, Integer> names = new HashMap<String, Integer>();
        for (ReferenceDescriptor referenceDescriptor : this.referenceDescriptors.values()) {
            ElementBindingDef elementBinding = new ElementBindingDef();
            elementBinding.setReferenceXLocator(referenceDescriptor.referenceXLoc);
            String name = referenceDescriptor.absoluteXLoc.getLastStep().getName();
            elementBinding.setName(SchematronTransformerUtil.toUniqueName(SchematronTransformerUtil.lowerFirstChar(name), names));
            elementBinding.setElementName(name);
            elementBinding.setPrefix(referenceDescriptor.absoluteXLoc.getLastStep().getPrefix());
            elementBinding.setAttr(referenceDescriptor.absoluteXLoc.isAttr());
            for (LocationPathDescriptor locationPathDescriptor : referenceDescriptor.locationPathDescriptors) {
                ElementBindingUseDef elementBindingUse = new ElementBindingUseDef();
                String useName = locationPathDescriptor.getPropertyName();
                if (locationPathDescriptor.getPredicationPath() != null) {
                    useName = elementBinding.getName() + "_" + useName;
                }
                elementBindingUse.setName(useName);
                elementBindingUse.setUse(locationPathDescriptor.getUseType());
                if (locationPathDescriptor.isInAPredicate() && !elementBinding.isAttr()) {
                    elementBindingUse.setInAPredicate(true);
                    elementBindingUse.setBoundVia(locationPathDescriptor.getPredicationPath().getPropertyName());
                }
                this.checkForStructuralUsage(names, referenceDescriptor, elementBindingUse, locationPathDescriptor.getPathsUsedInPredicate());
                elementBinding.addUse(elementBindingUse);
            }
            elementBinding.setXLocator(referenceDescriptor.absoluteXLoc);
            XLocator resetPointXLoc = referenceDescriptor.absoluteXLoc.commonRootWith(this.invocationPointXLoc);
            if ((this.chainPointXLoc == null || resetPointXLoc.isSubPathOf(this.chainPointXLoc)) && !resetPointXLoc.stripAttr().equals(this.invocationPointXLoc.stripAttr())) {
                if (referenceDescriptor.isInAPredicate) {
                    elementBinding.setResetPoint(this.findInnermostRepeatPoint(referenceDescriptor.absoluteXLoc));
                } else {
                    elementBinding.setResetPoint(resetPointXLoc);
                }
            }
            this.bindingContext.addElementBinding(elementBinding);
        }
    }

    private void checkForStructuralUsage(Map<String, Integer> names, ReferenceDescriptor referenceDescriptor, ElementBindingUseDef elementBindingUse, List<LocationPathDescriptor> pathsUsedInPredicate) {
        for (LocationPathDescriptor pathUsedInPredicate : pathsUsedInPredicate) {
            String predicatePath = pathUsedInPredicate.getPath().getEffectivePathString();
            XLocator absolutePredicateLoc = XLocator.create(predicatePath).relativeTo(referenceDescriptor.absoluteXLoc);
            if (referenceDescriptor.absoluteXLoc.isSubPathOf(absolutePredicateLoc)) {
                elementBindingUse.setStructureUsage(true);
            }
            elementBindingUse.setBoundVia(elementBindingUse.getName());
            this.checkForRequiredAncestorPaths(names, referenceDescriptor, elementBindingUse, predicatePath);
        }
    }

    private void checkForRequiredAncestorPaths(Map<String, Integer> names, ReferenceDescriptor referenceDescriptor, ElementBindingUseDef elementBindingUse, String predicatePath) {
        XLocator relativePredicateLoc = XLocator.create(predicatePath);
        XLocator parentLoc = referenceDescriptor.absoluteXLoc;
        int top = -relativePredicateLoc.top();
        for (int i = 0; i < top; ++i) {
            parentLoc = parentLoc.subPath(-1);
            ElementBindingDef parentBinding = new ElementBindingDef();
            String parentName = SchematronTransformerUtil.toUniqueName(SchematronTransformerUtil.lowerFirstChar(parentLoc.getLastStep().getName()), names);
            parentBinding.setName(parentName);
            parentBinding.setElementName(parentLoc.getLastStep().getName());
            parentBinding.setName(parentName);
            parentBinding.setPrefix(parentLoc.getLastStep().getPrefix());
            parentBinding.setXLocator(parentLoc);
            ElementBindingUseDef parentBindingUse = new ElementBindingUseDef();
            parentBindingUse.setUse(LocationPathUseType.Value);
            parentBindingUse.setStructureUsage(true);
            parentBindingUse.setName(parentName);
            parentBindingUse.setBoundVia(elementBindingUse.getName());
            parentBinding.addUse(parentBindingUse);
            this.bindingContext.addElementBinding(parentBinding);
        }
    }

    private void generateChaining() {
        if (this.debug) {
            System.out.println("chain point: " + this.chainPointXLoc);
        }
        if (this.chainPointXLoc != null) {
            ElementReferenceDef chainPoint = new ElementReferenceDef();
            chainPoint.setXLocator(this.chainPointXLoc);
            this.bindingContext.setChainPoint(chainPoint);
            XLocator commonXLoc = this.chainPointXLoc.commonRootWith(this.contextXLoc);
            int differenceToContext = commonXLoc.size() - this.contextXLoc.size();
            block5: for (ElementBindingDef elementBinding : this.bindingContext.getElementBindings()) {
                XLocator referenceXLoc = elementBinding.getReferenceXLocator();
                if (referenceXLoc == null) continue;
                ReferenceDescriptor descriptor = this.referenceDescriptors.get(referenceXLoc);
                switch (descriptor.availability) {
                    case FORWARD_OF_REPEATING: {
                        SchemaModelPathRelationship relationship;
                        if (referenceXLoc.isRelative()) {
                            referenceXLoc = referenceXLoc.raiseBy(differenceToContext);
                        }
                        if ((relationship = this.schemaModel.findPathRelationshipToContext(this.chainPointXLoc, referenceXLoc)).getAvailability() != SchemaModelPathAvailability.FORWARD_OF_REPEATING) {
                            this.ruleClassDef.raiseProblem(CompilerProblem.Category.ERROR, "expected 'forward of repeating' availability for binding with reference: " + elementBinding.getReferenceXLocator() + " (chain point: " + this.chainPointXLoc + ")");
                            continue block5;
                        }
                        XLocator path = relationship.getPathDescriptor().getPath().subPath(-1);
                        elementBinding.setUnbindPoint(path.commonRootWith(descriptor.absoluteXLoc));
                        elementBinding.setPropogateOnChaining(true);
                        break;
                    }
                    case AVAILABLE_BEFORE: {
                        elementBinding.setPropogateOnChaining(true);
                        break;
                    }
                    case FORWARD_OF_NON_REPEATING: 
                    case AVAILABLE_IN: {
                        elementBinding.setUnbindPoint(this.chainPointXLoc);
                    }
                }
                if (!this.debug) continue;
                System.out.println("reference: " + elementBinding.getReferenceXLocator() + "[unbind at: " + elementBinding.getUnbindPoint() + ", reset at: " + elementBinding.getResetPoint() + ", propagate: " + elementBinding.isPropogateOnChaining() + "]");
            }
        }
    }

    private boolean addLocationPathDescriptor(LocationPathDescriptor locationPathDescriptor) {
        XLocator referenceXLoc = XLocator.create(locationPathDescriptor.getEffectivePathString());
        boolean isContextElementRef = referenceXLoc == XLocator.DOT;
        boolean isInAPredicate = false;
        if (locationPathDescriptor.getPredicationPath() != null && !locationPathDescriptor.getEffectivePath().usesCurrent()) {
            isInAPredicate = true;
            LocationPathDescriptor predicationPath = locationPathDescriptor.getPredicationPath();
            XLocator predicationLoc = XLocator.create(predicationPath.getEffectivePathString());
            referenceXLoc = referenceXLoc.relativeTo(predicationLoc);
        }
        if (!isContextElementRef) {
            ReferenceDescriptor descriptor = this.referenceDescriptors.get(referenceXLoc);
            if (descriptor == null) {
                descriptor = new ReferenceDescriptor(referenceXLoc, this.contextXLoc, isInAPredicate);
                this.addReferenceDescriptor(referenceXLoc, descriptor);
            }
            descriptor.locationPathDescriptors.add(locationPathDescriptor);
        }
        return isContextElementRef;
    }

    private ReferenceDescriptor addReferenceDescriptor(XLocator referenceXLoc, ReferenceDescriptor descriptor) {
        return this.referenceDescriptors.put(referenceXLoc, descriptor);
    }

    private static class ReferenceDescriptor {
        final List<LocationPathDescriptor> locationPathDescriptors = new ArrayList<LocationPathDescriptor>();
        final XLocator referenceXLoc;
        final XLocator absoluteXLoc;
        SchemaModelPathAvailability availability;
        boolean isInAPredicate;

        ReferenceDescriptor(XLocator referenceXLoc, XLocator contextXLoc, boolean isPredicatingPath) {
            this.referenceXLoc = referenceXLoc;
            this.absoluteXLoc = referenceXLoc.relativeTo(contextXLoc);
            this.isInAPredicate = isPredicatingPath;
        }

        public String toString() {
            return "ReferenceDescriptor [abs=" + this.absoluteXLoc + ", ref=" + this.referenceXLoc + ", availability=" + (Object)((Object)this.availability) + ", isInAPredicate=" + this.isInAPredicate + ", descriptors=" + this.locationPathDescriptors + "]";
        }
    }
}

