/*
 * Decompiled with CFR 0.152.
 */
package com.gsl.schematron.transformer;

import com.gsl.schematron.transformer.BindingContext;
import com.gsl.schematron.transformer.RuleContext;
import com.gsl.schematron.transformer.SchemaManager;
import com.gsl.schematron.transformer.def.ElementBindingDef;
import com.gsl.schematron.transformer.def.ElementBindingUseDef;
import com.gsl.schematron.transformer.def.InvocationPointDef;
import com.gsl.schematron.transformer.def.RuleClassDef;
import com.gsl.xs.SchemaModel;
import com.gsl.xs.SchemaModelPathDescriptor;
import com.gsl.xs.XLocator;
import com.gsl.xs.XLocatorStep;
import com.gsl.xslt2java.LocationPathUseType;
import com.gsl.xslt2java.XPathToJavaTranslator;
import com.gsl.xslt2java.xpath.LocationPath;
import java.util.HashSet;
import java.util.Set;

public class BindingGenerator2 {
    private final RuleClassDef ruleClassDef;
    private final BindingContext bindingContext;

    public static BindingContext generateBindings(RuleClassDef ruleClassDef, XLocator contextXLoc) {
        return new BindingGenerator2(ruleClassDef, contextXLoc).generateBindings();
    }

    protected BindingContext generateBindings() {
        Set<XLocator> expressionXLocs = this.ruleClassDef.getRequiredExpressionXLocs();
        XLocator contextXLoc = this.bindingContext.getContextXLocator();
        Set<XLocator> requiredXLocs = BindingGenerator2.calculateRequiredXLocs(contextXLoc, expressionXLocs);
        Set<XLocator> filteredXLocs = BindingGenerator2.filterIntermediatePaths(requiredXLocs);
        for (XLocator el : expressionXLocs) {
            if (el.getSteps().size() != 0) continue;
            filteredXLocs.add(contextXLoc);
        }
        SchemaModel schemaModel = this.obtainSchemaModel(contextXLoc, requiredXLocs);
        requiredXLocs.addAll(this.findExtraPaths(schemaModel, filteredXLocs));
        Set<XLocator> endpoints = BindingGenerator2.filterIntermediatePaths(requiredXLocs);
        HashSet<XLocator> xlocsToIgnore = new HashSet<XLocator>();
        for (XLocator el : requiredXLocs) {
            if (!el.getLastStep().equals(XLocatorStep.CHILDREN)) continue;
            xlocsToIgnore.add(el);
        }
        requiredXLocs.removeAll(xlocsToIgnore);
        int i = 0;
        for (XLocator loc : requiredXLocs) {
            ++i;
            if (loc == XLocator.ROOT) continue;
            ElementBindingDef binding = new ElementBindingDef();
            binding.setXLocator(loc);
            binding.setPrefix(loc.getLastStep().getPrefix());
            binding.setElementName(loc.getLastStep().getName());
            ElementBindingUseDef use = new ElementBindingUseDef();
            use.setBoundVia("binding");
            use.setName(loc.getLastStep().getName());
            binding.setName(loc.getLastStep().getName() + i);
            if (loc.equals(contextXLoc)) {
                binding.setBindContext(true);
            }
            if (loc.isAbsolute() && loc.size() == 1) {
                binding.setMakeRootNode(true);
            }
            if (endpoints.contains(loc)) {
                use.setUse(LocationPathUseType.Leaf);
            } else {
                use.setUse(LocationPathUseType.Branch);
            }
            binding.addUse(use);
            this.bindingContext.addElementBinding(binding);
        }
        XLocator outerMostLoc = contextXLoc;
        for (XLocator loc : requiredXLocs) {
            outerMostLoc = outerMostLoc.commonRootWith(loc);
        }
        InvocationPointDef invocationPoint = new InvocationPointDef();
        invocationPoint.setXLocator(outerMostLoc);
        this.bindingContext.setInvocationPoint(invocationPoint);
        return this.bindingContext;
    }

    private Set<XLocator> findExtraPaths(SchemaModel schemaModel, Set<XLocator> currentXLocs) {
        HashSet<XLocator> pathsToAdd = new HashSet<XLocator>();
        for (XLocator loc : currentXLocs) {
            Set<SchemaModelPathDescriptor> children;
            SchemaModelPathDescriptor desc;
            if (loc.getLastStep().equals(XLocatorStep.CHILDREN)) {
                loc = loc.dropLastStep();
            }
            if ((desc = schemaModel.findPathDescriptor(loc)) == null || (children = desc.getChildren()).isEmpty()) continue;
            for (SchemaModelPathDescriptor childDescriptor : children) {
                pathsToAdd.add(childDescriptor.getPath());
            }
        }
        return pathsToAdd;
    }

    public static Set<XLocator> filterIntermediatePaths(Set<XLocator> requiredXLocs) {
        HashSet<XLocator> filteredSet = new HashSet<XLocator>(requiredXLocs);
        for (XLocator xloc : requiredXLocs) {
            for (XLocator xloc2 : requiredXLocs) {
                if (xloc.equals(xloc2) || !xloc.isSubPathOf(xloc2)) continue;
                filteredSet.remove(xloc);
            }
        }
        return filteredSet;
    }

    public BindingGenerator2(RuleClassDef ruleClassDef, XLocator contextXLoc) {
        this.ruleClassDef = ruleClassDef;
        this.bindingContext = new BindingContext(contextXLoc);
    }

    private static Set<XLocator> calculateRequiredXLocs(XLocator contextXLoc, Set<XLocator> expressionXLocs) {
        RuleContext ruleContext = new RuleContext(contextXLoc);
        HashSet<XLocator> resolvedXLocs = new HashSet<XLocator>();
        for (XLocator loc : expressionXLocs) {
            resolvedXLocs.addAll(ruleContext.calculatePathInterval(loc));
        }
        return resolvedXLocs;
    }

    private static Set<XLocator> makeXLocators(Set<LocationPath> expressionPaths) {
        HashSet<XLocator> locators = new HashSet<XLocator>();
        for (LocationPath path : expressionPaths) {
            String pathString = path.getEffectivePathString();
            XLocator loc = XLocator.create(pathString);
            locators.add(loc);
        }
        return locators;
    }

    private SchemaModel obtainSchemaModel(XLocator contextXLoc, Set<XLocator> xlocs) {
        XLocator path = contextXLoc;
        for (XLocator xloc : xlocs) {
            if (xloc.uniqueNamespaceCount() <= path.uniqueNamespaceCount()) continue;
            path = xloc;
        }
        SchemaManager schemaManager = this.ruleClassDef.getContext().getTransformer().getContext().getSchemaManager();
        return schemaManager.getSchemaModel(this.ruleClassDef.getContext().getSchemaInfoDef().getNamespacePrefixMapper(), path);
    }

    public static Set<LocationPath> calculateRequiredPaths(LocationPath contextPath, Set<LocationPath> expressionPaths) {
        HashSet<LocationPath> results = new HashSet<LocationPath>();
        Set<XLocator> expressionXLocs = BindingGenerator2.makeXLocators(expressionPaths);
        XLocator contextXLoc = XLocator.create(contextPath.getEffectivePathString());
        Set<XLocator> resolvedXLocs = BindingGenerator2.calculateRequiredXLocs(contextXLoc, expressionXLocs);
        for (XLocator loc : resolvedXLocs) {
            results.add(XPathToJavaTranslator.parseLocationPath(loc.toString()));
        }
        return results;
    }
}

