/*
 * Decompiled with CFR 0.152.
 */
package com.gsl.schematron.transformer;

import com.gsl.schematron.transformer.Compilable;
import com.gsl.schematron.transformer.CompilerProblem;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class CompilableResult {
    private final List<Compilable> compilables = new ArrayList<Compilable>();
    private final Map<Object, List<CompilerProblem>> problems = new IdentityHashMap<Object, List<CompilerProblem>>();

    public void addCompilable(Compilable compilable) {
        this.compilables.add(compilable);
    }

    public void clear() {
        this.compilables.clear();
    }

    public Collection<Compilable> getCompilables() {
        return Collections.unmodifiableList(this.compilables);
    }

    void raiseProblem(CompilerProblem problem) {
        List<CompilerProblem> problemList = this.problems.get(problem.getTarget());
        if (problemList == null) {
            problemList = new LinkedList<CompilerProblem>();
            this.problems.put(problem.getTarget(), problemList);
        }
        problemList.add(problem);
    }

    public List<CompilerProblem> listProblems(Object target) {
        return this.problems.get(target);
    }

    public Map<Object, List<CompilerProblem>> getCompilerProblemMap() {
        return this.problems;
    }

    public void clearProblems() {
        this.problems.clear();
    }
}

