/*
 * Decompiled with CFR 0.152.
 */
package com.gsl.schematron.transformer;

import bizrules.AbstractElementProcessor;
import bizrules.registry.DocumentEventDetail;
import com.gsl.schematron.transformer.DefinitionContext;
import com.gsl.schematron.transformer.def.AssertDef;
import com.gsl.schematron.transformer.def.PatternDef;
import com.gsl.schematron.transformer.def.RuleDef;
import java.util.ArrayList;
import java.util.List;
import xmldoc.Attribute;
import xmldoc.AttributeHelper;
import xmldoc.DocumentEventType;

public class DefinitionCollector
extends AbstractElementProcessor {
    private final DefinitionContext context;
    private final List<PatternDef> patternDefs = new ArrayList<PatternDef>();
    private PatternDef patternDef;
    private RuleDef ruleDef;
    private AssertDef assertDef;

    public DefinitionCollector(DefinitionContext context) {
        this.context = context;
    }

    public List<PatternDef> getPatternDefs() {
        return this.patternDefs;
    }

    @Override
    protected String[] getApplicableNamespaces() {
        return null;
    }

    @Override
    protected void initializeValueBindings() {
        this.getValueBinder().add("http://purl.oclc.org/dsdl/schematron", "/schema/pattern", "patternInfo");
        this.getValueBinder().add("http://purl.oclc.org/dsdl/schematron", "/schema/pattern/rule", "ruleInfo");
        this.getValueBinder().add("http://purl.oclc.org/dsdl/schematron", "/schema/pattern/rule/assert", "assertInfo");
        this.getValueBinder().add("http://purl.oclc.org/dsdl/schematron", "/schema/pattern/rule/report", "reportInfo");
    }

    @Override
    protected void initializeEventBindings() {
        this.getEventBinder().add("http://purl.oclc.org/dsdl/schematron", "/schema/pattern", "endPattern", DocumentEventType.endElement);
        this.getEventBinder().add("http://purl.oclc.org/dsdl/schematron", "/schema/pattern/rule", "endRule", DocumentEventType.endElement);
        this.getEventBinder().add("http://purl.oclc.org/dsdl/schematron", "/schema/pattern/rule/assert", "endAssert", DocumentEventType.endElement);
        this.getEventBinder().add("http://purl.oclc.org/dsdl/schematron", "/schema/pattern/rule/report", "endReport", DocumentEventType.endElement);
    }

    public void setPatternInfo(Attribute[] attrs) {
        this.patternDef = new PatternDef();
        this.patternDef.setId(AttributeHelper.getAttributeValue(attrs, "id"));
        this.patternDef.setContext(this.context);
    }

    public void setRuleInfo(Attribute[] attrs) {
        this.ruleDef = new RuleDef();
        String contextPath = AttributeHelper.getAttributeValue(attrs, "context");
        this.ruleDef.setContext(contextPath);
        this.ruleDef.setPatternDefId(this.patternDef.getId());
    }

    public void setAssertInfo(String message, Attribute[] attrs) {
        this.assertDef = new AssertDef();
        this.assertDef.setId(AttributeHelper.getAttributeValue(attrs, "id"));
        this.assertDef.setTest(AttributeHelper.getAttributeValue(attrs, "test"));
        this.assertDef.setDiagnostics(AttributeHelper.getAttributeValue(attrs, "diagnostics"));
        this.assertDef.setDefaultMessage(message);
        this.assertDef.setNegate(true);
    }

    public void setReportInfo(String message, Attribute[] attrs) {
        this.setAssertInfo(message, attrs);
        this.assertDef.setNegate(false);
    }

    public void endAssert(DocumentEventDetail event) {
        this.ruleDef.addAssertDef(this.assertDef);
        this.assertDef = null;
    }

    public void endReport(DocumentEventDetail event) {
        this.endAssert(event);
    }

    public void endRule(DocumentEventDetail event) {
        this.patternDef.addRuleDef(this.ruleDef);
        this.ruleDef = null;
    }

    public void endPattern(DocumentEventDetail event) {
        this.patternDefs.add(this.patternDef);
        this.patternDef.setOrdinal(this.patternDefs.size());
        this.patternDef = null;
    }
}

