/*
 * Decompiled with CFR 0.152.
 */
package com.gsl.schematron.transformer;

import com.gsl.schematron.transformer.CompilerProblem;
import com.gsl.schematron.transformer.SchematronTransformer;
import com.gsl.schematron.transformer.SchematronTransformerParams;
import com.gsl.schematron.transformer.SchematronTransformerUtil;
import com.gsl.schematron.transformer.def.DiagnosticDef;
import com.gsl.schematron.transformer.def.PatternDef;
import com.gsl.schematron.transformer.def.SchemaInfoDef;
import java.util.List;

public class DefinitionContext {
    private final SchematronTransformer transformer;
    private final int ordinal;
    private final SchematronTransformerParams params;
    private SchemaInfoDef schemaInfoDef;
    private List<PatternDef> patternDefs;
    private List<DiagnosticDef> diagnosticDefs;
    private String servicePackageName;

    public DefinitionContext(SchematronTransformer ruleGenerator, int ordinal, SchematronTransformerParams params, String servicePackageName) {
        this.transformer = ruleGenerator;
        this.ordinal = ordinal;
        this.params = params;
        this.servicePackageName = servicePackageName;
    }

    public int getOrdinal() {
        return this.ordinal;
    }

    public SchematronTransformer getTransformer() {
        return this.transformer;
    }

    public SchematronTransformerParams getParams() {
        return this.params;
    }

    public String getServicePackageName() {
        return this.servicePackageName;
    }

    public SchemaInfoDef getSchemaInfoDef() {
        return this.schemaInfoDef;
    }

    public void setSchemaInfoDef(SchemaInfoDef schemaInfoDef) {
        this.schemaInfoDef = schemaInfoDef;
    }

    public List<PatternDef> getPatternDefs() {
        return this.patternDefs;
    }

    public void setPatternDefs(List<PatternDef> patternDefs) {
        this.patternDefs = patternDefs;
    }

    public List<DiagnosticDef> getDiagnosticDefs() {
        return this.diagnosticDefs;
    }

    public void setDiagnosticDefs(List<DiagnosticDef> diagnosticDefs) {
        this.diagnosticDefs = diagnosticDefs;
    }

    public String getOrdinalId() {
        return SchematronTransformerUtil.toCharOrd(this.getOrdinal());
    }

    public void raiseProblem(CompilerProblem.Category category, String message) {
        this.getTransformer().getContext().raiseProblem(this, category, message);
    }

    public void raiseProblem(CompilerProblem.Category category, String message, Throwable cause) {
        this.getTransformer().getContext().raiseProblem(this, category, message, cause);
    }
}

