/*
 * Decompiled with CFR 0.152.
 */
package com.gsl.schematron.transformer;

import com.gsl.schematron.transformer.BindingContext;
import com.gsl.schematron.transformer.BindingGenerator;
import com.gsl.schematron.transformer.BindingGenerator2;
import com.gsl.schematron.transformer.CompilerProblem;
import com.gsl.schematron.transformer.DefinitionContext;
import com.gsl.schematron.transformer.DiagnosticsCollator;
import com.gsl.schematron.transformer.SchematronTransformerUtil;
import com.gsl.schematron.transformer.def.AssertDef;
import com.gsl.schematron.transformer.def.DiagnosticDef;
import com.gsl.schematron.transformer.def.ElementBindingDef;
import com.gsl.schematron.transformer.def.ElementBindingUseDef;
import com.gsl.schematron.transformer.def.PatternDef;
import com.gsl.schematron.transformer.def.RuleClassDef;
import com.gsl.schematron.transformer.def.RuleDef;
import com.gsl.xs.XLocator;
import com.gsl.xslt2java.TranslationContext;
import com.gsl.xslt2java.XPathToJavaTranslator;
import com.gsl.xslt2java.expression.Expression;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public class DefinitionProcessor {
    private final DefinitionContext context;

    public DefinitionProcessor(DefinitionContext context) {
        this.context = context;
    }

    public void processDefinitions() throws Exception {
        this.processRules();
    }

    private void processRules() {
        DiagnosticsCollator diagnosticsCollator = new DiagnosticsCollator(this.context);
        for (PatternDef patternDef : this.context.getPatternDefs()) {
            LinkedList<RuleDef> ruleDefList;
            HashMap<String, LinkedList<RuleDef>> contextToRuleDefMap = new HashMap<String, LinkedList<RuleDef>>();
            for (RuleDef ruleDef : patternDef.getRuleDefs()) {
                ruleDefList = (LinkedList<RuleDef>)contextToRuleDefMap.get(ruleDef.getContext());
                if (ruleDefList == null) {
                    ruleDefList = new LinkedList<RuleDef>();
                    contextToRuleDefMap.put(ruleDef.getContext(), ruleDefList);
                }
                ruleDefList.add(ruleDef);
            }
            for (String contextString : contextToRuleDefMap.keySet()) {
                ruleDefList = (List)contextToRuleDefMap.get(contextString);
                RuleClassDef ruleClassDef = this.buildRuleClassDef(patternDef, ruleDefList, diagnosticsCollator);
                if (!ruleDefList.isEmpty()) {
                    BindingContext bindingContext;
                    if (ruleClassDef.hasComplexPaths()) {
                        ruleClassDef.setUseNewClassTemplate(true);
                        bindingContext = BindingGenerator2.generateBindings(ruleClassDef, XLocator.create(contextString));
                    } else {
                        bindingContext = BindingGenerator.generateBindings(this.context, ruleClassDef, XLocator.create(contextString));
                        if (bindingContext.getChainPoint() != null || this.hasStructuresBoundViaAnotherName(bindingContext)) {
                            ruleClassDef.clearProblems();
                            ruleClassDef.raiseProblem(CompilerProblem.Category.INFO, "Found a chain point in pattern " + ruleClassDef.getPatternDef().getId() + " for artefacts " + this.context.getServicePackageName() + ", switching to rule3.vm");
                            ruleClassDef.setUseNewClassTemplate(true);
                            bindingContext = BindingGenerator2.generateBindings(ruleClassDef, XLocator.create(contextString));
                        }
                    }
                    ruleClassDef.setBindingContext(bindingContext);
                    ruleClassDef.setJavaClassNameMajor(bindingContext.getContextXLocator().getStep(-1).getName());
                    ruleClassDef.setJavaPackageName(SchematronTransformerUtil.findJavaPackage(this.context, ruleClassDef));
                    this.context.getTransformer().getContext().addCompilable(ruleClassDef);
                    continue;
                }
                this.context.raiseProblem(CompilerProblem.Category.WARNING, "no rule class definition, discarding: pattern='" + patternDef.getId() + "', context='" + contextString + "'");
            }
        }
    }

    private boolean hasStructuresBoundViaAnotherName(BindingContext bindingContext) {
        boolean result = false;
        for (ElementBindingDef binding : bindingContext.getElementBindings()) {
            for (ElementBindingUseDef use : binding.getUses()) {
                if (!use.isStructureUsage() || use.getBoundVia() == null || use.isInAPredicate() || use.getName().equals(use.getBoundVia())) continue;
                result = true;
            }
        }
        return result;
    }

    private RuleClassDef buildRuleClassDef(PatternDef patternDef, List<RuleDef> ruleDefList, DiagnosticsCollator diagnosticsCollator) {
        RuleClassDef ruleClassDef = new RuleClassDef();
        ruleClassDef.setPatternDef(patternDef);
        Iterator<RuleDef> ruleDefIterator = ruleDefList.iterator();
        while (ruleDefIterator.hasNext()) {
            RuleDef ruleDef = ruleDefIterator.next();
            this.parseAssertions(ruleDef);
            if (!ruleDef.getAssertDefs().isEmpty()) {
                this.buildDiagnostics(ruleDef, diagnosticsCollator);
                ruleClassDef.addRuleDef(ruleDef);
                continue;
            }
            this.context.raiseProblem(CompilerProblem.Category.WARNING, "no assertions for rule, discarding: pattern='" + patternDef.getId() + "', context='" + ruleDef.getContext() + "'");
            ruleDefIterator.remove();
        }
        return ruleClassDef;
    }

    private void parseAssertions(RuleDef ruleDef) {
        TranslationContext translationContext = XPathToJavaTranslator.makeContext();
        Iterator<AssertDef> assertionIterator = ruleDef.getAssertDefs().iterator();
        while (assertionIterator.hasNext()) {
            AssertDef assertDef = assertionIterator.next();
            String test = assertDef.getTest();
            try {
                XPathToJavaTranslator translator = new XPathToJavaTranslator(translationContext);
                Expression expression = translator.translate(test);
                if (expression != null) {
                    assertDef.setExpression(expression);
                    continue;
                }
                this.context.raiseProblem(CompilerProblem.Category.ERROR, "failed to compile xpath expression: '" + test + "'");
                assertionIterator.remove();
            }
            catch (Exception e) {
                this.context.raiseProblem(CompilerProblem.Category.ERROR, "exception occurred compiling xpath expression: '" + test + "'", e);
            }
        }
    }

    private void buildDiagnostics(RuleDef ruleDef, DiagnosticsCollator diagnosticsCollator) {
        for (AssertDef assertDef : ruleDef.getAssertDefs()) {
            String errorCodeText = null;
            String messageText = null;
            String debugText = null;
            if (assertDef.getDiagnostics() != null) {
                DiagnosticsCollator.Diagnostics diagnostics = diagnosticsCollator.getDiagnostics(assertDef.getDiagnostics());
                DiagnosticDef errorCodeDiagnostic = diagnostics.getErrorCode();
                DiagnosticDef messageDiagnostic = diagnostics.getTransactionalMessage();
                DiagnosticDef debugDiagnostic = diagnostics.getDebugMessage();
                if (errorCodeDiagnostic == null || messageDiagnostic == null) {
                    this.context.raiseProblem(CompilerProblem.Category.WARNING, "diagnostics info not found for assertion: diagnostics='" + assertDef.getDiagnostics() + "', context='" + ruleDef.getContext() + "'");
                }
                if (errorCodeDiagnostic != null) {
                    errorCodeText = errorCodeDiagnostic.getText();
                }
                if (messageDiagnostic != null) {
                    messageText = messageDiagnostic.getText();
                }
                if (debugDiagnostic != null) {
                    debugText = debugDiagnostic.getText();
                }
            } else {
                this.context.raiseProblem(CompilerProblem.Category.WARNING, "no diagnostics reference for assertion: default message='" + assertDef.getDebugMessage() + "', context='" + ruleDef.getContext() + "'");
            }
            if (errorCodeText == null) {
                errorCodeText = assertDef.getId() + ": ERROR CODE NOT FOUND";
            }
            if (messageText == null) {
                messageText = assertDef.getId() + ": MESSAGE TEXT NOT FOUND";
            }
            assertDef.setErrorCode(errorCodeText);
            assertDef.setMessage(messageText);
            assertDef.setDebugMessage(debugText);
        }
    }
}

