/*
 * Decompiled with CFR 0.152.
 */
package com.gsl.schematron.transformer;

import com.gsl.schematron.transformer.CompilerProblem;
import com.gsl.schematron.transformer.DefinitionContext;
import com.gsl.schematron.transformer.def.DiagnosticDef;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

class DiagnosticsCollator {
    private static final String ERROR_CODE_KEY_PREFIX = "errorCode.";
    private static final String TRANSACTIONAL_MSG_KEY_PREFIX = "transactional.";
    private static final String DEBUG_MSG_KEY_PREFIX = "debug.";
    private final Map<String, DiagnosticDef> diagnosticsMap = new HashMap<String, DiagnosticDef>();

    DiagnosticsCollator(DefinitionContext context) {
        for (DiagnosticDef diagnosticDef : context.getDiagnosticDefs()) {
            String diagnosticId = diagnosticDef.getId();
            if (this.diagnosticsMap.containsKey(diagnosticId)) {
                context.raiseProblem(CompilerProblem.Category.WARNING, "duplicate diagnostic id: '" + diagnosticId + "'");
                continue;
            }
            this.diagnosticsMap.put(diagnosticId, diagnosticDef);
        }
    }

    Diagnostics getDiagnostics(String keys) {
        return new Diagnostics(keys.split("[ ]+"));
    }

    DiagnosticDef getDiagnosticDef(String key) {
        return this.diagnosticsMap.get(key);
    }

    class Diagnostics {
        private final DiagnosticDef errorCode;
        private final DiagnosticDef transactionalMessage;
        private final DiagnosticDef debugMessage;
        private final String[] unknownKeys;

        private Diagnostics(String[] keys) {
            this.errorCode = this.findDiagnostic(DiagnosticsCollator.ERROR_CODE_KEY_PREFIX, keys);
            this.transactionalMessage = this.findDiagnostic(DiagnosticsCollator.TRANSACTIONAL_MSG_KEY_PREFIX, keys);
            this.debugMessage = this.findDiagnostic(DiagnosticsCollator.DEBUG_MSG_KEY_PREFIX, keys);
            this.unknownKeys = this.collateUnknownKeys(keys);
        }

        DiagnosticDef getErrorCode() {
            return this.errorCode;
        }

        DiagnosticDef getTransactionalMessage() {
            return this.transactionalMessage;
        }

        DiagnosticDef getDebugMessage() {
            return this.debugMessage;
        }

        String[] getUnknownKeys() {
            return this.unknownKeys;
        }

        private DiagnosticDef findDiagnostic(String prefix, String[] keys) {
            for (int i = 0; i < keys.length; ++i) {
                String key = keys[i];
                if (key == null || !key.startsWith(prefix)) continue;
                keys[i] = null;
                return DiagnosticsCollator.this.getDiagnosticDef(key);
            }
            return null;
        }

        private String[] collateUnknownKeys(String[] keys) {
            ArrayList<String> list = new ArrayList<String>(keys.length);
            for (String key : keys) {
                if (key == null) continue;
                list.add(key);
            }
            return list.toArray(new String[list.size()]);
        }
    }
}

