/*
 * Decompiled with CFR 0.152.
 */
package com.gsl.schematron.transformer;

import com.gsl.xs.XLocator;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;

public class RelativeLocators {
    private static final Set<XLocator> EMPTY_LOCATOR_SET = Collections.emptySet();
    private Map<XLocator, Set<XLocator>> locatorMap = new HashMap<XLocator, Set<XLocator>>();

    public boolean isEmpty() {
        return this.locatorMap.isEmpty();
    }

    public Set<XLocator> getRoots() {
        return this.locatorMap.keySet();
    }

    public Set<XLocator> getXPaths(XLocator root) {
        Set<XLocator> locators = this.locatorMap.get(root);
        return locators != null ? locators : EMPTY_LOCATOR_SET;
    }

    public void addLocator(XLocator root, XLocator xpath) {
        if (root.isRelative()) {
            throw new IllegalArgumentException("root must be absolute: " + root);
        }
        if (!xpath.isRelative()) {
            throw new IllegalArgumentException("xpath must be relative: " + xpath);
        }
        Set<XLocator> locators = this.locatorMap.get(root);
        if (locators == null) {
            locators = new LinkedHashSet<XLocator>();
            this.locatorMap.put(root, locators);
        }
        locators.add(xpath);
    }

    public void combine(RelativeLocators other) {
        for (XLocator root : other.getRoots()) {
            Set<XLocator> xpaths = other.getXPaths(root);
            for (XLocator xpath : xpaths) {
                this.addLocator(root, xpath);
            }
        }
    }
}

