/*
 * Decompiled with CFR 0.152.
 */
package com.gsl.schematron.transformer;

import com.gsl.docValidator.DocumentValidator;
import com.gsl.docValidator.DocumentValidatorImplementor;
import com.gsl.docValidator.ValidationParams;
import com.gsl.docValidator.ValidationResultInterface;
import com.gsl.docValidator.ValidatorProvider;
import com.gsl.io.core.stream.Streamable;
import com.gsl.logging.LoggerFactory;
import com.gsl.schematron.transformer.RelativeLocators;
import com.gsl.schematron.transformer.RelativeLocatorsCollector;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import xmldoc.util.ClasspathEntityResolver;

public class RelativeLocatorsParser
extends DocumentValidator
implements ValidatorProvider {
    private static final Logger log = LoggerFactory.getLogger(RelativeLocatorsParser.class.getName());
    public static final String NAMESPACE_RLOC = "http://rloc";
    private static final String[][] ENTITY_RESOLUTION_TABLE = new String[][]{{"http://rloc", "/rloc.xsd"}};
    private RelativeLocatorsCollector collector;

    public static RelativeLocators parseRelativeLocators(Set<Streamable> rlocResources) {
        RelativeLocators relativeLocators = new RelativeLocators();
        for (Streamable rlocResource : rlocResources) {
            RelativeLocators tmpRelativeLocators = new RelativeLocators();
            RelativeLocatorsParser parser = new RelativeLocatorsParser(tmpRelativeLocators);
            parser.getController().addProvider(parser);
            try {
                ValidationResultInterface result = parser.getController().validate((DocumentValidator)parser, rlocResource.openInputStream(), null, null);
                if (!result.getProcessingErrors().isEmpty()) {
                    log.log(Level.SEVERE, "there were errors parsing the relative locators artifacts");
                    tmpRelativeLocators = null;
                }
            }
            catch (Exception e) {
                log.log(Level.SEVERE, "there were errors parsing the relative locators artifacts", e);
                tmpRelativeLocators = null;
            }
            if (tmpRelativeLocators == null) continue;
            relativeLocators.combine(tmpRelativeLocators);
        }
        return relativeLocators;
    }

    private RelativeLocatorsParser(RelativeLocators relativeLocators) {
        this.collector = new RelativeLocatorsCollector(relativeLocators);
    }

    @Override
    public ClasspathEntityResolver getEntityResolver(ValidationParams params) {
        return new ClasspathEntityResolver(ENTITY_RESOLUTION_TABLE);
    }

    @Override
    public void init(DocumentValidatorImplementor validator) {
    }

    @Override
    public void provisionNamespace(String namespace, DocumentValidatorImplementor validator) {
        if (NAMESPACE_RLOC.equals(namespace)) {
            validator.addElementProcessor(this.collector);
        }
    }

    @Override
    public void destroy() {
    }
}

