/*
 * Decompiled with CFR 0.152.
 */
package com.gsl.schematron.transformer;

import com.gsl.xs.XLocator;
import java.util.HashSet;
import java.util.Set;

public class RuleContext {
    private final XLocator contextPath;

    public RuleContext(XLocator contextPath) {
        assert (contextPath != null);
        if (contextPath.isRelative()) {
            throw new IllegalArgumentException("The context path must be absolute");
        }
        this.contextPath = contextPath;
    }

    public RuleContext(String contextPathString) {
        this(XLocator.create(contextPathString));
    }

    public Set<XLocator> calculatePathInterval(String endpoint) {
        XLocator endpointLoc = XLocator.create(endpoint);
        return this.calculatePathInterval(endpointLoc);
    }

    Set<XLocator> calculatePathInterval(XLocator endpointLoc) {
        HashSet<XLocator> result = new HashSet<XLocator>();
        if (endpointLoc.isRelative()) {
            int size = endpointLoc.size();
            for (int i = 0; i <= size; ++i) {
                XLocator subPath = endpointLoc.subPath(0, i);
                XLocator appended = this.contextPath.append(subPath);
                result.add(appended);
            }
        } else {
            int i;
            result.add(XLocator.ROOT);
            for (i = 0; i <= endpointLoc.size(); ++i) {
                result.add(endpointLoc.subPath(0, i));
            }
            for (i = 0; i <= this.contextPath.size(); ++i) {
                result.add(this.contextPath.subPath(0, i));
            }
        }
        return result;
    }
}

