/*
 * Decompiled with CFR 0.152.
 */
package com.gsl.schematron.transformer;

import com.gsl.schematron.transformer.SchematronTransformerException;
import com.gsl.xs.SchemaModel;
import com.gsl.xs.SchemaModelFactory;
import com.gsl.xs.XLocator;
import com.gsl.xs.XLocatorStep;
import java.util.HashMap;
import java.util.Map;
import xmldoc.NamespacePrefixMapper;

public class SchemaManager {
    private final SchemaModelFactory factory;
    private Map<Object, SchemaModel> models = new HashMap<Object, SchemaModel>();

    public SchemaManager(SchemaModelFactory factory) {
        this.factory = factory;
    }

    public SchemaModel getSchemaModel(NamespacePrefixMapper mapper, XLocator path) {
        try {
            Object cacheKey = SchemaManager.createCacheKey(path);
            SchemaModel model = this.models.get(cacheKey);
            if (model == null) {
                model = this.factory.createModel(mapper, path);
                this.models.put(cacheKey, model);
            }
            return model;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new SchematronTransformerException(e);
        }
    }

    private static Object createCacheKey(XLocator path) {
        StringBuilder b = new StringBuilder();
        String prefix = null;
        for (XLocatorStep step : path.stripAttr()) {
            if (step.getPrefix().equals(prefix)) continue;
            prefix = step.getPrefix();
            b.append(step).append(';');
        }
        return b.toString();
    }
}

