/*
 * Decompiled with CFR 0.152.
 */
package com.gsl.schematron.transformer;

import com.gsl.docValidator.DocumentValidator;
import com.gsl.docValidator.DocumentValidatorImplementor;
import com.gsl.docValidator.PostValidationDelegate;
import com.gsl.docValidator.ValidationException;
import com.gsl.docValidator.ValidationParams;
import com.gsl.docValidator.ValidationResultInterface;
import com.gsl.docValidator.ValidatorProvider;
import com.gsl.schematron.transformer.DefinitionCollector;
import com.gsl.schematron.transformer.DefinitionContext;
import com.gsl.schematron.transformer.DiagnosticsCollector;
import com.gsl.schematron.transformer.SchemaInfoCollector;
import com.gsl.schematron.transformer.SchematronParserResult;
import java.io.Reader;
import java.util.List;
import xmldoc.util.ClasspathEntityResolver;

public class SchematronParser
extends DocumentValidator
implements ValidatorProvider,
PostValidationDelegate {
    public static final String NAMESPACE_SCHEMATRON = "http://purl.oclc.org/dsdl/schematron";
    public static final String NAMESPACE_VALIDATION = "http://www.hmrc.gov.uk/internal/validation";
    public static final String NAMESPACE_ERROR_RESPONSE = "http://www.govtalk.gov.uk/CM/errorresponse";
    private static final String[][] ENTITY_RESOLUTION_TABLE = new String[][]{{"http://purl.oclc.org/dsdl/schematron", "/schematron1-5.xsd"}, {"http://www.hmrc.gov.uk/internal/validation", "/validationresponse2.xsd"}, {"http://www.govtalk.gov.uk/CM/errorresponse", "/errorresponse-v2.0.xsd"}};
    private final DefinitionContext context;
    private final SchemaInfoCollector schemaInfoCollector;
    private final DefinitionCollector patternDefCollector;
    private final DiagnosticsCollector diagnosticsCollector;

    public static SchematronParserResult parseSchematron(DefinitionContext context, Reader input) throws ValidationException {
        SchematronParser parser = new SchematronParser(context);
        parser.getController().addProvider(parser);
        return (SchematronParserResult)parser.getController().validate((DocumentValidator)parser, input, (ValidationParams)context.getParams(), (PostValidationDelegate)parser);
    }

    private SchematronParser(DefinitionContext context) {
        this.context = context;
        this.schemaInfoCollector = new SchemaInfoCollector();
        this.patternDefCollector = new DefinitionCollector(context);
        this.diagnosticsCollector = new DiagnosticsCollector(context);
    }

    public ValidationResultInterface createResult(List processingErrors, ValidationParams params) {
        try {
            this.context.setSchemaInfoDef(this.schemaInfoCollector.getSchemaInfoDef());
            this.context.setPatternDefs(this.patternDefCollector.getPatternDefs());
            this.context.setDiagnosticDefs(this.diagnosticsCollector.getDiagnosticDefs());
            SchematronParserResult result = new SchematronParserResult();
            return result;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public ClasspathEntityResolver getEntityResolver(ValidationParams params) {
        return new ClasspathEntityResolver("SchematronParser", ENTITY_RESOLUTION_TABLE);
    }

    @Override
    public void init(DocumentValidatorImplementor validator) {
    }

    @Override
    public void provisionNamespace(String namespace, DocumentValidatorImplementor validator) {
        if (NAMESPACE_SCHEMATRON.equals(namespace)) {
            validator.addElementProcessor(this.schemaInfoCollector);
            validator.addElementProcessor(this.patternDefCollector);
            validator.addElementProcessor(this.diagnosticsCollector);
        }
    }

    @Override
    public void destroy() {
    }
}

