/*
 * Decompiled with CFR 0.152.
 */
package com.gsl.schematron.transformer;

import com.gsl.io.core.stream.Streamable;
import com.gsl.util.HashCode;
import com.gsl.util.ObjectUtil;

public class SchematronResource {
    private final Streamable streamable;
    private final String javaPackageName;
    private final int hashCode;

    public SchematronResource(Streamable streamable, String servicePackageName) {
        this.streamable = streamable;
        this.javaPackageName = servicePackageName;
        this.hashCode = this.calculateHashCode();
    }

    public String getJavaPackageName() {
        return this.javaPackageName;
    }

    public Streamable getStreamable() {
        return this.streamable;
    }

    private int calculateHashCode() {
        int result = 23;
        result = HashCode.hash(result, this.streamable);
        result = HashCode.hash(result, this.javaPackageName);
        return result;
    }

    public int hashCode() {
        return this.hashCode;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o == null || o.getClass() != this.getClass()) {
            return false;
        }
        SchematronResource otherResource = (SchematronResource)o;
        return this.streamable.equals(otherResource.streamable) && ObjectUtil.nullSafeEquals(this.javaPackageName, otherResource.javaPackageName);
    }
}

