/*
 * Decompiled with CFR 0.152.
 */
package com.gsl.schematron.transformer;

import com.gsl.schematron.transformer.Compilable;
import com.gsl.schematron.transformer.CompilableResult;
import com.gsl.schematron.transformer.CompilerProblem;
import com.gsl.schematron.transformer.SchemaManager;
import java.util.List;

public class SchematronTransformerContext {
    private final CompilableResult result = new CompilableResult();
    private SchemaManager schemaManager;
    private String validatorErrorCode = null;
    private String validatorErrorMessage = null;

    public CompilableResult getCompilableResult() {
        return this.result;
    }

    public SchemaManager getSchemaManager() {
        return this.schemaManager;
    }

    public void setSchemaManager(SchemaManager schemaManager) {
        this.schemaManager = schemaManager;
    }

    public String getValidatorErrorCode() {
        return this.validatorErrorCode;
    }

    public String getValidatorErrorMessage() {
        return this.validatorErrorMessage;
    }

    public void setValidatorError(String code, String message) {
        this.validatorErrorCode = code;
        this.validatorErrorMessage = message;
    }

    public void addCompilable(Compilable compilable) {
        this.result.addCompilable(compilable);
    }

    public void raiseProblem(Object target, CompilerProblem.Category category, String message) {
        this.result.raiseProblem(new CompilerProblem(category, message, target));
    }

    public void raiseProblem(Object target, CompilerProblem.Category category, String message, Throwable cause) {
        this.result.raiseProblem(new CompilerProblem(category, message, target, cause));
    }

    public List<CompilerProblem> listProblems(Object target) {
        return this.result.listProblems(target);
    }

    public void clearProblems() {
        this.result.clearProblems();
    }
}

