/*
 * Decompiled with CFR 0.152.
 */
package com.gsl.schematron.transformer;

import com.gsl.docValidator.ValidationException;
import com.gsl.io.core.stream.FileStreamable;
import com.gsl.logging.LoggerFactory;
import com.gsl.schematron.transformer.Compilable;
import com.gsl.schematron.transformer.CompilableResult;
import com.gsl.schematron.transformer.CompilerProblem;
import com.gsl.schematron.transformer.DefinitionContext;
import com.gsl.schematron.transformer.DefinitionProcessor;
import com.gsl.schematron.transformer.RelativeLocators;
import com.gsl.schematron.transformer.SchemaManager;
import com.gsl.schematron.transformer.SchematronParser;
import com.gsl.schematron.transformer.SchematronParserResult;
import com.gsl.schematron.transformer.SchematronResource;
import com.gsl.schematron.transformer.SchematronTransformer;
import com.gsl.schematron.transformer.SchematronTransformerContext;
import com.gsl.schematron.transformer.SchematronTransformerParams;
import com.gsl.schematron.transformer.ValidatorInitialiserClassDef;
import com.gsl.schematron.transformer.def.NSDeclDef;
import com.gsl.schematron.transformer.def.RuleClassDef;
import com.gsl.xs.SchemaModelUtil;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import xmldoc.util.EntityResolver;

public class SchematronTransformerImpl
implements SchematronTransformer {
    private static final Logger log = LoggerFactory.getLogger(SchematronTransformerImpl.class.getName());
    private final EntityResolver entityResolver;
    private RelativeLocators relativeLocators;
    private SchematronTransformerContext context;

    public SchematronTransformerImpl() {
        this(null);
    }

    public SchematronTransformerImpl(EntityResolver entityResolver) {
        this.entityResolver = entityResolver;
    }

    @Override
    public RelativeLocators getRelativeLocators() {
        return this.relativeLocators;
    }

    @Override
    public void setRelativeLocators(RelativeLocators relativeLocators) {
        this.relativeLocators = relativeLocators;
    }

    @Override
    public SchematronTransformerContext getContext() {
        return this.context;
    }

    @Override
    public CompilableResult transform(String[] schematronFilepaths, SchematronTransformerParams params) {
        SchematronResource[] resources = new SchematronResource[schematronFilepaths.length];
        for (int i = 0; i < schematronFilepaths.length; ++i) {
            String filepath = schematronFilepaths[i];
            FileStreamable streamable = new FileStreamable(filepath);
            resources[i] = new SchematronResource(streamable, null);
        }
        return this.transform(resources, params);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CompilableResult transform(SchematronResource[] schematronResources, SchematronTransformerParams params) {
        try {
            this.context = new SchematronTransformerContext();
            params.getParserParams().setDoSchemaValidation(false);
            List<DefinitionContext> contexts = null;
            try {
                contexts = this.processSchemas(schematronResources, params);
                for (DefinitionContext context : contexts) {
                    new DefinitionProcessor(context).processDefinitions();
                }
                this.makeJavaClassNamesUnique();
            }
            catch (Exception e) {
                this.context.raiseProblem(this, CompilerProblem.Category.ERROR, "exception was raised during artifact compilation", e);
            }
            this.handleProblems();
            this.createInitialisers(contexts, params);
            CompilableResult compilableResult = this.context.getCompilableResult();
            return compilableResult;
        }
        finally {
            this.context = null;
        }
    }

    private List<DefinitionContext> processSchemas(SchematronResource[] schematronResources, SchematronTransformerParams params) throws IOException, ValidationException {
        LinkedList<DefinitionContext> definitionContexts = new LinkedList<DefinitionContext>();
        for (int i = 0; i < schematronResources.length; ++i) {
            log.fine("processing schematron resource: " + schematronResources[i]);
            this.context.setSchemaManager(new SchemaManager(SchemaModelUtil.createDefaultSchemaModelFactory(this.entityResolver)));
            BufferedReader input = new BufferedReader(new InputStreamReader(schematronResources[i].getStreamable().openInputStream(), Charset.forName("UTF-8")));
            DefinitionContext definitionContext = new DefinitionContext(this, i + 1, params, schematronResources[i].getJavaPackageName());
            definitionContexts.add(definitionContext);
            SchematronParserResult result = SchematronParser.parseSchematron(definitionContext, input);
            if (result.getProcessingErrors().isEmpty()) continue;
            this.context.raiseProblem(result, CompilerProblem.Category.ERROR, "error processing schematron resource: '" + schematronResources[i] + "'");
        }
        return definitionContexts;
    }

    private void makeJavaClassNamesUnique() {
        HashMap<String, LinkedList<RuleClassDef>> javaClassNameMap = new HashMap<String, LinkedList<RuleClassDef>>();
        for (Compilable compilable : this.context.getCompilableResult().getCompilables()) {
            if (!(compilable instanceof RuleClassDef)) continue;
            RuleClassDef ruleClassDef = (RuleClassDef)compilable;
            LinkedList<RuleClassDef> ruleClassDefs = (LinkedList<RuleClassDef>)javaClassNameMap.get(ruleClassDef.getJavaClassNameMajor());
            if (ruleClassDefs == null) {
                ruleClassDefs = new LinkedList<RuleClassDef>();
                javaClassNameMap.put(ruleClassDef.getJavaClassNameMajor(), ruleClassDefs);
            }
            ruleClassDefs.add(ruleClassDef);
        }
        for (List ruleClassDefs : javaClassNameMap.values()) {
            if (ruleClassDefs.size() <= 1) continue;
            int index = 1;
            for (RuleClassDef ruleClassDef : ruleClassDefs) {
                ruleClassDef.setJavaClassNameMinor(Integer.toString(index++));
            }
        }
    }

    private void createInitialisers(List<DefinitionContext> definitionContexts, SchematronTransformerParams params) {
        HashSet<String> servicePackageNames = new HashSet<String>();
        if (definitionContexts != null) {
            for (DefinitionContext definitionContext : definitionContexts) {
                String servicePackageName = definitionContext.getServicePackageName();
                servicePackageNames.add(servicePackageName);
            }
        }
        if (!servicePackageNames.isEmpty()) {
            for (String servicePackageName : servicePackageNames) {
                ValidatorInitialiserClassDef initialiserClassDef = this.addInitialiser(params);
                initialiserClassDef.setServicePackageName(servicePackageName);
                for (DefinitionContext definitionContext : definitionContexts) {
                    for (NSDeclDef nsDeclDef : definitionContext.getSchemaInfoDef().getNsDecls()) {
                        initialiserClassDef.addNamespacePrefixMapping(nsDeclDef.getUri(), nsDeclDef.getPrefix());
                    }
                }
            }
        } else {
            this.addInitialiser(params);
        }
    }

    private ValidatorInitialiserClassDef addInitialiser(SchematronTransformerParams params) {
        ValidatorInitialiserClassDef initialiserClassDef = new ValidatorInitialiserClassDef();
        initialiserClassDef.setDefaultJavaPackage(params.getDefaultJavaPackage());
        if (this.context.getValidatorErrorCode() != null) {
            initialiserClassDef.setValidatorErrorCode(this.context.getValidatorErrorCode());
            initialiserClassDef.setValidatorErrorMessage(this.context.getValidatorErrorMessage());
        }
        this.context.addCompilable(initialiserClassDef);
        return initialiserClassDef;
    }

    private void handleProblems() {
        int numErrors = 0;
        for (List<CompilerProblem> problems : this.context.getCompilableResult().getCompilerProblemMap().values()) {
            for (CompilerProblem problem : problems) {
                Level logLevel = Level.INFO;
                switch (problem.getCategory()) {
                    case WARNING: {
                        logLevel = Level.WARNING;
                        break;
                    }
                    case ERROR: {
                        logLevel = Level.SEVERE;
                        ++numErrors;
                    }
                }
                log.log(logLevel, problem.toString(), problem.getCause());
            }
        }
        if (numErrors > 0) {
            this.context.setValidatorError("9999", "errors encountered during artifact compilation, please consult the logs for more info");
            this.context.getCompilableResult().clear();
        }
    }
}

