/*
 * Decompiled with CFR 0.152.
 */
package com.gsl.schematron.transformer;

import com.gsl.docValidator.ValidationParams;
import com.gsl.schematron.transformer.JavaPackageMapping;
import com.gsl.util.properties.NullParamProperties;
import com.gsl.util.properties.ParamProperties;
import java.util.ArrayList;
import java.util.List;

public class SchematronTransformerParams
extends ValidationParams {
    public static final String X_PROP_TRANSFORMER_DEBUG_ENABLED = "x_transformer_debug_enabled";
    private ParamProperties paramProps;
    private List<JavaPackageMapping> javaPackageMappings = new ArrayList<JavaPackageMapping>();
    private String ruleJavaPackage = null;
    private String defaultJavaPackage;

    public SchematronTransformerParams() {
        this(NullParamProperties.INSTANCE);
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        SchematronTransformerParams clone = (SchematronTransformerParams)super.clone();
        clone.paramProps = (ParamProperties)this.paramProps.clone();
        clone.javaPackageMappings = new ArrayList<JavaPackageMapping>(this.javaPackageMappings);
        return clone;
    }

    public SchematronTransformerParams(ParamProperties paramProps) {
        this.paramProps = paramProps;
    }

    public List getJavaPackageMappings() {
        return this.javaPackageMappings;
    }

    public void addJavaPackageMapping(String namespace, String packageName) {
        this.javaPackageMappings.add(new JavaPackageMapping(namespace, packageName));
    }

    public String getRuleJavaPackage() {
        return this.ruleJavaPackage != null ? this.ruleJavaPackage : this.defaultJavaPackage;
    }

    public void setRuleJavaPackage(String ruleJavaPackage) {
        this.ruleJavaPackage = ruleJavaPackage;
    }

    public ParamProperties getParamProps() {
        return this.paramProps;
    }

    public boolean isDebugEnabled() {
        return this.paramProps.getBoolean(X_PROP_TRANSFORMER_DEBUG_ENABLED, false);
    }

    public String getDefaultJavaPackage() {
        return this.defaultJavaPackage;
    }

    public void setDefaultJavaPackage(String defaultJavaPackage) {
        this.defaultJavaPackage = defaultJavaPackage;
    }
}

