/*
 * Decompiled with CFR 0.152.
 */
package com.gsl.schematron.transformer;

import com.gsl.schematron.transformer.DefinitionContext;
import com.gsl.schematron.transformer.JavaPackageMapping;
import com.gsl.schematron.transformer.def.AssertDef;
import com.gsl.schematron.transformer.def.RuleClassDef;
import java.util.List;
import java.util.Map;

public class SchematronTransformerUtil {
    public static final SchematronTransformerUtil INSTANCE = new SchematronTransformerUtil();

    private SchematronTransformerUtil() {
    }

    public static String findJavaPackage(DefinitionContext context, RuleClassDef ruleClassDef) {
        List mappings = context.getParams().getJavaPackageMappings();
        for (JavaPackageMapping mapping : mappings) {
            if (!ruleClassDef.getApplicableNamespaces().contains(mapping.getNamespaceURI())) continue;
            return mapping.getPackageName();
        }
        String packageName = context.getParams().getRuleJavaPackage();
        if (context.getServicePackageName() != null) {
            packageName = packageName + "." + context.getServicePackageName();
        }
        return packageName;
    }

    public static String toUniqueName(String name, Map<String, Integer> names) {
        Integer index = names.get(name);
        if (index == null) {
            index = 1;
        } else {
            Integer n = index;
            Integer n2 = index = Integer.valueOf(index + 1);
        }
        names.put(name, index);
        return name + "_" + SchematronTransformerUtil.toCharOrd(index);
    }

    public static String toCheckCall(AssertDef assertDef) {
        return (assertDef.isNegate() ? "assert" : "report") + '_' + assertDef.getJavaId();
    }

    public static String upperFirstChar(String string) {
        return string.length() > 1 ? Character.toUpperCase(string.charAt(0)) + string.substring(1) : string.toUpperCase();
    }

    public static String lowerFirstChar(String string) {
        return string.length() > 1 ? Character.toLowerCase(string.charAt(0)) + string.substring(1) : string.toLowerCase();
    }

    public static String escapeString(String string) {
        if (string == null) {
            return "";
        }
        string = string.indexOf(34) >= 0 ? string.replaceAll("\\\"", "\\\\\"") : string;
        string = string.replaceAll("\n", "\\\\n");
        string = string.replace("\\-", "\\\\-");
        return string;
    }

    public static String toCharOrd(int ord) {
        int n = 0;
        int m = 1;
        int k = ord;
        while (k > 0) {
            k /= 26;
            ++n;
            m *= 26;
        }
        StringBuilder b = new StringBuilder(n);
        for (int i = 0; i < n; ++i) {
            int c = ord / (m /= 26) % 26;
            b.append((char)(65 + c - (i == 0 ? 1 : 0)));
        }
        return b.toString();
    }
}

