/*
 * Decompiled with CFR 0.152.
 */
package com.gsl.schematron.transformer.def;

import com.gsl.schematron.transformer.AbstractCompilableClass;
import com.gsl.schematron.transformer.BindingContext;
import com.gsl.schematron.transformer.CompilerProblem;
import com.gsl.schematron.transformer.DefinitionContext;
import com.gsl.schematron.transformer.def.PatternDef;
import com.gsl.schematron.transformer.def.RuleDef;
import com.gsl.xs.XLocator;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class RuleClassDef
extends AbstractCompilableClass {
    private PatternDef patternDef;
    private String javaPackageName;
    private String javaClassNameMajor;
    private String javaClassNameMinor = "";
    private final List<RuleDef> ruleDefs = new ArrayList<RuleDef>();
    private BindingContext bindingContext;
    private boolean useNewClassTemplate = false;

    public boolean hasComplexPaths() {
        boolean result = false;
        for (RuleDef ruleDef : this.ruleDefs) {
            if (!ruleDef.hasComplexPaths()) continue;
            result = true;
            break;
        }
        return result;
    }

    @Override
    public Set<String> getApplicableNamespaces() {
        return this.bindingContext.getApplicableNamespaces();
    }

    public BindingContext getBindingContext() {
        return this.bindingContext;
    }

    public void setBindingContext(BindingContext bindingContext) {
        this.bindingContext = bindingContext;
    }

    public DefinitionContext getContext() {
        return this.patternDef.getContext();
    }

    public PatternDef getPatternDef() {
        return this.patternDef;
    }

    public void setPatternDef(PatternDef patternDef) {
        this.patternDef = patternDef;
    }

    public String getJavaPackageName() {
        return this.javaPackageName;
    }

    public void setJavaPackageName(String javaPackageName) {
        this.javaPackageName = javaPackageName;
    }

    public String getJavaClassNameMajor() {
        return this.javaClassNameMajor;
    }

    public void setJavaClassNameMajor(String javaClassNameMajor) {
        this.javaClassNameMajor = javaClassNameMajor;
    }

    public String getJavaClassNameMinor() {
        return this.javaClassNameMinor;
    }

    public void setJavaClassNameMinor(String javaClassNameMinor) {
        this.javaClassNameMinor = javaClassNameMinor;
    }

    public List<RuleDef> getRuleDefs() {
        return this.ruleDefs;
    }

    public void addRuleDef(RuleDef ruleDef) {
        this.ruleDefs.add(ruleDef);
    }

    @Override
    public String getPackageName() {
        return this.javaPackageName;
    }

    @Override
    public String getClassName() {
        return this.javaClassNameMajor + "Rule" + this.javaClassNameMinor;
    }

    public void raiseProblem(CompilerProblem.Category category, String message) {
        this.getContext().getTransformer().getContext().raiseProblem(this, category, message);
    }

    public void raiseProblem(CompilerProblem.Category category, String message, Throwable cause) {
        this.getContext().getTransformer().getContext().raiseProblem(this, category, message, cause);
    }

    public void clearProblems() {
        this.getContext().getTransformer().getContext().clearProblems();
    }

    @Override
    public List<CompilerProblem> listProblems() {
        return this.getContext().getTransformer().getContext().listProblems(this);
    }

    public void setUseNewClassTemplate(boolean useNewClassTemplate) {
        this.useNewClassTemplate = useNewClassTemplate;
    }

    public boolean useNewClassTemplate() {
        return this.useNewClassTemplate;
    }

    public Set<XLocator> getRequiredExpressionXLocs() {
        HashSet<XLocator> requiredExpressionXLocs = new HashSet<XLocator>();
        for (RuleDef ruleDef : this.ruleDefs) {
            requiredExpressionXLocs.addAll(ruleDef.getRequiredExpressionXLocs());
        }
        return requiredExpressionXLocs;
    }
}

