/*
 * Decompiled with CFR 0.152.
 */
package com.gsl.schematron.transformer.def;

import com.gsl.schematron.transformer.def.AssertDef;
import com.gsl.xs.XLocator;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class RuleDef {
    private int ordinal;
    private String patternDefId;
    private String context;
    private final List<AssertDef> assertDefs = new ArrayList<AssertDef>();

    public int getOrdinal() {
        return this.ordinal;
    }

    public void setOrdinal(int ordinal) {
        this.ordinal = ordinal;
    }

    public void setPatternDefId(String patternDefId) {
        this.patternDefId = patternDefId;
    }

    public String getContext() {
        return this.context;
    }

    public void setContext(String context) {
        this.context = context;
    }

    public List<AssertDef> getAssertDefs() {
        return this.assertDefs;
    }

    public void addAssertDef(AssertDef assertDef) {
        this.assertDefs.add(assertDef);
        assertDef.setOrdinal(this.assertDefs.size());
    }

    public String getId() {
        return this.patternDefId + "_" + this.getOrdinal();
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append("Rule:\n");
        buf.append(" context: '" + this.context + "'\n");
        buf.append(" asserts:\n");
        for (AssertDef element : this.assertDefs) {
            buf.append("  ").append(element);
        }
        return buf.toString();
    }

    public boolean hasComplexPaths() {
        for (AssertDef assertDef : this.assertDefs) {
            if (!assertDef.hasComplexPaths()) continue;
            return true;
        }
        return false;
    }

    public Set<XLocator> getRequiredExpressionXLocs() {
        HashSet<XLocator> requiredExpressionXLocs = new HashSet<XLocator>();
        for (AssertDef assertDef : this.assertDefs) {
            requiredExpressionXLocs.addAll(assertDef.getRequiredExpressionXLocs());
        }
        return requiredExpressionXLocs;
    }
}

