/*
 * Decompiled with CFR 0.152.
 */
package com.gsl.schematron.transformer.model;

import com.gsl.schematron.transformer.model.Context;
import com.gsl.schematron.transformer.model.PathError;
import com.gsl.schematron.transformer.model.ProtoDocument;
import com.gsl.schematron.transformer.model.Schema;

public class ContextImpl
implements Context {
    private String contextPath;
    private ProtoDocument protoDoc;

    public ContextImpl(String contextPath, Schema schema) throws PathError {
        this.contextPath = contextPath;
        this.protoDoc = schema.makeProtoDocument(contextPath);
    }

    @Override
    public boolean canOccurBefore(String locationPath) throws PathError {
        return this.protoDoc.canOccurBefore(this.contextPath, locationPath);
    }

    @Override
    public String getPath() {
        return this.contextPath;
    }

    @Override
    public ProtoDocument getProtoDocument() {
        return this.protoDoc;
    }

    @Override
    public boolean canOccurMoreThanOnce() {
        return this.getProtoDocument().canOccurMoreThanOnce(this.contextPath);
    }

    @Override
    public boolean pathRefersToMoreThanOnceInstance(String requiredPath) throws PathError {
        return this.canOccurMoreThanOnce() && this.canOccurBefore(requiredPath);
    }

    @Override
    public String getOuterRepeatPoint(String path) throws PathError {
        return this.getProtoDocument().getOuterRepeatPoint(this.getPath(), path);
    }
}

