/*
 * Decompiled with CFR 0.152.
 */
package com.gsl.schematron.transformer.model;

import com.gsl.schematron.transformer.model.Assertion;
import com.gsl.schematron.transformer.model.Context;
import com.gsl.schematron.transformer.model.PathError;
import com.gsl.schematron.transformer.model.ProtoDocument;
import com.gsl.schematron.transformer.model.Rule;
import com.gsl.xs.XLocator;
import com.gsl.xslt2java.LocationPathDescriptor;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class RuleImpl
implements Rule {
    private final Context context;
    private final List<Assertion> assertions = new ArrayList<Assertion>();
    private String invocationPoint;

    public RuleImpl(Context context) {
        this.context = context;
        this.invocationPoint = context.getPath();
    }

    @Override
    public String getInvocationPoint() throws PathError {
        for (Assertion assertion : this.assertions) {
            Set<LocationPathDescriptor> requiredLocationPaths = assertion.getRequiredLocationPaths();
            for (LocationPathDescriptor lpd : requiredLocationPaths) {
                String path = lpd.getPathString();
                ProtoDocument protoDoc = this.context.getProtoDocument();
                if (!protoDoc.canOccurBefore(this.invocationPoint, path)) continue;
                this.invocationPoint = this.commonRoot(this.invocationPoint, path);
            }
        }
        return this.invocationPoint;
    }

    private String commonRoot(String path1, String path2) {
        XLocator loc1 = XLocator.create(path1);
        XLocator loc2 = XLocator.create(path2);
        XLocator commonRoot = loc1.commonRootWith(loc2);
        return commonRoot.toString();
    }

    public void addAssertion(Assertion assertion) {
        this.assertions.add(assertion);
    }

    @Override
    public boolean needsChaining() throws PathError {
        boolean result = false;
        if (this.context.canOccurMoreThanOnce()) {
            for (LocationPathDescriptor lpd : this.getRequiredLocationPaths()) {
                String requiredPath = lpd.getPathString();
                if (!this.context.canOccurBefore(requiredPath) || !this.context.pathRefersToMoreThanOnceInstance(requiredPath)) continue;
                result = true;
                break;
            }
        }
        return result;
    }

    private Set<LocationPathDescriptor> getRequiredLocationPaths() {
        HashSet<LocationPathDescriptor> requiredPaths = new HashSet<LocationPathDescriptor>();
        for (Assertion assertion : this.assertions) {
            requiredPaths.addAll(assertion.getRequiredLocationPaths());
        }
        return requiredPaths;
    }

    @Override
    public String getChainPoint() throws PathError {
        String result = null;
        if (this.needsChaining()) {
            for (LocationPathDescriptor requiredPath : this.getRequiredLocationPaths()) {
                String path = requiredPath.getPathString();
                if (!this.context.canOccurBefore(path) || !this.context.pathRefersToMoreThanOnceInstance(path)) continue;
                String chainPoint = this.context.getOuterRepeatPoint(path);
                if (result != null && !result.equals(chainPoint)) {
                    throw new PathError("More than one chain point found - can't handle that yet");
                }
                result = chainPoint;
            }
        }
        return result;
    }
}

