/*
 * Decompiled with CFR 0.152.
 */
package com.gsl.schematron.transformer.ruleclass;

import com.gsl.schematron.transformer.BindingContext;
import com.gsl.schematron.transformer.SchematronTransformerUtil;
import com.gsl.schematron.transformer.def.AssertDef;
import com.gsl.schematron.transformer.def.ElementBindingDef;
import com.gsl.schematron.transformer.def.ElementBindingUseDef;
import com.gsl.schematron.transformer.def.RuleClassDef;
import com.gsl.schematron.transformer.def.RuleDef;
import com.gsl.schematron.transformer.ruleclass.ArrayInitializer;
import com.gsl.schematron.transformer.ruleclass.BranchBinding;
import com.gsl.schematron.transformer.ruleclass.EventBinding;
import com.gsl.schematron.transformer.ruleclass.LeafBinding;
import com.gsl.schematron.transformer.ruleclass.MemberVariable;
import com.gsl.schematron.transformer.ruleclass.NewExpression;
import com.gsl.schematron.transformer.ruleclass.Null;
import com.gsl.schematron.transformer.ruleclass.RuleClass;
import com.gsl.schematron.transformer.ruleclass.Type;
import com.gsl.xslt2java.expression.Expression;
import com.gsl.xslt2java.expression.StringLiteral;
import java.util.ArrayList;
import xmldoc.DocumentEventType;

public class ClassGenerator {
    private final RuleClass ruleClass;
    private final RuleClassDef def;

    public ClassGenerator(RuleClass ruleClass) {
        this.ruleClass = ruleClass;
        this.def = ruleClass.getDef();
    }

    public static RuleClass generate(RuleClassDef def) {
        RuleClass ruleClass = new RuleClass(def.getClassName(), def);
        ClassGenerator generator = new ClassGenerator(ruleClass);
        return generator.doGenerate();
    }

    protected RuleClass doGenerate() {
        ArrayList<Expression> subcodes = new ArrayList<Expression>();
        for (RuleDef ruleDef : this.def.getRuleDefs()) {
            for (AssertDef assertDef : ruleDef.getAssertDefs()) {
                subcodes.add(new StringLiteral("\"" + assertDef.getJavaId() + "\""));
            }
        }
        this.ruleClass.addMember(new MemberVariable(Type.Primitives.STRING_ARRAY, "SUBCODES", new ArrayInitializer(subcodes), true));
        this.ruleClass.addMember(new MemberVariable(Type.XPath.nodeType, "contextNode", new Null()));
        this.ruleClass.addMember(new MemberVariable(Type.XPath.nodeType, "currentNode", new Null()));
        this.ruleClass.addMember(new MemberVariable(Type.XPath.nodeListType, "contextNodes", new NewExpression(Type.XPath.nodeArrayListType)));
        for (ElementBindingDef binding : this.def.getBindingContext().getElementBindings()) {
            this.setupRuleBindings(binding);
            this.setupUseBindings(binding);
        }
        return this.ruleClass;
    }

    private void setupRuleBindings(ElementBindingDef binding) {
        if (binding.getResetPoint() != null) {
            this.ruleClass.addEventBinding(new EventBinding(binding.getResetPoint().toBindingString(), "reset" + SchematronTransformerUtil.upperFirstChar(binding.getName()) + "_Binding", DocumentEventType.endElement));
        }
    }

    private void setupUseBindings(ElementBindingDef binding) {
        ElementBindingDef contextBinding;
        BindingContext bindingContext = this.ruleClass.getDef().getBindingContext();
        if (bindingContext.getContextElementBinding() != null && (contextBinding = bindingContext.getContextElementBinding()).getXLocator().equals(binding.getXLocator())) {
            bindingContext.setContextElementBinding(null);
            binding.setBindContext(true);
        }
        for (ElementBindingUseDef bindingUse : binding.getUses()) {
            switch (bindingUse.getUse()) {
                case Value: {
                    if (bindingUse.getBoundVia() == null) break;
                }
                case Leaf: {
                    this.ruleClass.addLeafBinding(new LeafBinding(binding, bindingUse));
                    break;
                }
                case Branch: {
                    this.ruleClass.addBranchBinding(new BranchBinding(binding, bindingUse));
                    break;
                }
                case Sum: {
                    throw new UnsupportedOperationException("implement me!");
                }
                case Count: {
                    throw new UnsupportedOperationException("implement me!");
                }
            }
        }
    }
}

