/*
 * Decompiled with CFR 0.152.
 */
package com.gsl.schematron.transformer.ruleclass;

import com.gsl.schematron.transformer.ruleclass.Type;
import com.gsl.xslt2java.expression.Expression;

public class MemberVariable {
    private final Type type;
    private final String name;
    private final Expression initializer;
    private final boolean isStatic;

    public MemberVariable(Type type, String name, Expression initializer, boolean isStatic) {
        this.type = type;
        this.name = name;
        this.initializer = initializer;
        this.isStatic = isStatic;
    }

    public MemberVariable(Type type, String name, Expression initializer) {
        this(type, name, initializer, false);
    }

    public MemberVariable(Type type, String name) {
        this(type, name, null, false);
    }

    public String getDeclaration() {
        String result = "private " + this.type + " " + this.name;
        if (this.initializer != null) {
            result = result + " = " + this.initializer.asJavaExpression();
        }
        result = result + ";";
        return result;
    }

    public String toString() {
        return this.getDeclaration();
    }

    public Type getType() {
        return this.type;
    }

    public String getName() {
        return this.name;
    }

    public Expression getInitializer() {
        return this.initializer;
    }

    public boolean isStatic() {
        return this.isStatic;
    }
}

