/*
 * Decompiled with CFR 0.152.
 */
package com.gsl.schematron.transformer.ruleclass;

import com.gsl.schematron.transformer.AbstractCompilableClass;
import com.gsl.schematron.transformer.CompilerProblem;
import com.gsl.schematron.transformer.def.RuleClassDef;
import com.gsl.schematron.transformer.ruleclass.BranchBinding;
import com.gsl.schematron.transformer.ruleclass.EventBinding;
import com.gsl.schematron.transformer.ruleclass.LeafBinding;
import com.gsl.schematron.transformer.ruleclass.MemberVariable;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;

public class RuleClass
extends AbstractCompilableClass {
    private final String className;
    private final RuleClassDef def;
    private final List<MemberVariable> memberVariables = new ArrayList<MemberVariable>();
    private final List<EventBinding> eventBindings = new ArrayList<EventBinding>();
    private final List<LeafBinding> leafBindings = new ArrayList<LeafBinding>();
    private final List<BranchBinding> branchBindings = new ArrayList<BranchBinding>();

    public RuleClass(String className, RuleClassDef def) {
        this.className = className;
        this.def = def;
    }

    public RuleClassDef getDef() {
        return this.def;
    }

    public void addMember(MemberVariable memberVariable) {
        boolean duplicate = false;
        for (MemberVariable var : this.memberVariables) {
            if (!var.getName().equals(memberVariable.getName())) continue;
            duplicate = true;
            break;
        }
        if (!duplicate) {
            this.memberVariables.add(memberVariable);
        }
    }

    public void addBranchBinding(BranchBinding branchBinding) {
        String bindingName = branchBinding.getBinding().getPrefix() + "_" + branchBinding.getBinding().getName();
        branchBinding.getBinding().setName(bindingName);
        this.branchBindings.add(branchBinding);
    }

    public void addLeafBinding(LeafBinding leafBinding) {
        this.leafBindings.add(leafBinding);
        this.addMember(leafBinding.getMemberVar());
    }

    public List<MemberVariable> getMemberVariables() {
        return this.memberVariables;
    }

    @Override
    public String getClassName() {
        return this.className;
    }

    @Override
    public String getPackageName() {
        return this.def.getPackageName();
    }

    @Override
    public Set<String> getApplicableNamespaces() {
        return this.def.getApplicableNamespaces();
    }

    @Override
    public List<CompilerProblem> listProblems() {
        return this.def.listProblems();
    }

    public void addEventBinding(EventBinding eventBinding) {
        this.eventBindings.add(eventBinding);
    }

    public List<EventBinding> getEventBindings() {
        return this.eventBindings;
    }

    public List<LeafBinding> getLeafBindings() {
        return this.leafBindings;
    }

    public List<BranchBinding> getBranchBindings() {
        return this.branchBindings;
    }
}

