/*
 * Decompiled with CFR 0.152.
 */
package com.gsl.schematron.transformer.ruleclass;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class Type {
    public static final List<Type> EMPTY_LIST = Collections.unmodifiableList(new ArrayList());
    private final String name;
    private final List<Type> parameters;
    private final boolean array;

    public Type(String typeName, List<Type> parameters, boolean array) {
        assert (typeName != null);
        assert (parameters != null);
        this.name = typeName;
        this.parameters = parameters;
        this.array = array;
    }

    public Type(String name) {
        this(name, EMPTY_LIST, false);
    }

    public Type(String name, List<Type> parameters) {
        this(name, parameters, false);
    }

    public Type(String name, boolean array) {
        this(name, EMPTY_LIST, array);
    }

    public String getName() {
        return this.name;
    }

    public List<Type> getParameters() {
        return this.parameters;
    }

    public boolean isArray() {
        return this.array;
    }

    public String toString() {
        String result = this.name;
        if (!this.parameters.isEmpty()) {
            boolean first = true;
            result = result + "<";
            for (Type param : this.parameters) {
                if (!first) {
                    result = result + ", ";
                } else {
                    first = false;
                }
                result = result + param.toString();
            }
            result = result + ">";
        }
        if (this.array) {
            result = result + "[]";
        }
        return result;
    }

    public boolean equals(Object other) {
        boolean result = false;
        if (other != null && other.getClass() == this.getClass()) {
            Type that = (Type)other;
            result = this.name.equals(that.name) && this.parameters.equals(that.parameters) && this.array == that.array;
        }
        return result;
    }

    public int hashCode() {
        return this.name.hashCode() ^ this.parameters.hashCode() ^ (this.array ? 1 : 0);
    }

    public static class XPath {
        public static final Type nodeListType;
        public static final Type nodeArrayListType;
        public static final Type nodeType;
        public static final Type elementNodeType;

        static {
            nodeType = new Type("Node");
            elementNodeType = new Type("ElementNode");
            ArrayList<Type> params = new ArrayList<Type>();
            params.add(nodeType);
            nodeListType = new Type("List", params);
            nodeArrayListType = new Type("ArrayList", params);
        }
    }

    public static class Primitives {
        static final Type DOUBLE = new Type("double");
        static final Type INT = new Type("int");
        public static final Type STRING_ARRAY = new Type("String", true);
    }
}

