/*
 * Decompiled with CFR 0.152.
 */
package com.gsl.schematron.validator;

import com.gsl.docValidator.ValidationException;
import com.gsl.io.core.file.XMLFileNameFilter;
import com.gsl.io.core.stream.NullOutputStream;
import com.gsl.schematron.validator.api.SchematronValidator;
import com.gsl.schematron.validator.api.SchematronValidatorFactories;
import com.gsl.schematron.validator.api.SchematronValidatorFactory;
import com.gsl.schematron.validator.api.SchematronValidatorParams;
import com.gsl.schematron.validator.api.ValidationType;
import com.gsl.util.Stopwatch;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;

public class Sample {
    private final SchematronValidatorFactory validatorFactory;

    public static void main(String[] args) throws Exception {
        ArrayList<InputStream> streams = new ArrayList<InputStream>();
        Sample sample = new Sample();
        if (args.length != 1) {
            System.err.println("Usage: Sample <directory to process>");
            System.exit(1);
        }
        String directoryToProcess = args[0];
        File file = new File(directoryToProcess);
        String[] filesToProcess = new String[]{};
        Stopwatch stopwatch = new Stopwatch();
        stopwatch.start();
        int submissionCount = 0;
        for (int j = 0; j < 100000; ++j) {
            if (file.isDirectory()) {
                for (String fileName : filesToProcess = file.list(new XMLFileNameFilter())) {
                    streams.add(new FileInputStream(directoryToProcess + File.separatorChar + fileName));
                }
            }
            sample.doValidation(streams);
            submissionCount += streams.size();
            for (InputStream stream : streams) {
                stream.close();
            }
            streams.clear();
        }
        stopwatch.stop();
        System.out.println("Processed " + submissionCount + " submissions in " + stopwatch.elapsed() + "ms");
        double submissionsPerSecond = (double)submissionCount / ((double)stopwatch.elapsed() / 1000.0);
        System.out.println("That's " + submissionsPerSecond + " submissions per second");
    }

    private Sample() {
        SchematronValidatorParams params = new SchematronValidatorParams();
        params.setTemporaryDirpath("tmp");
        params.setRIMArtefactsDirectory("rimArtefacts");
        params.setLoggingLevel(Level.OFF);
        params.setValidationType(ValidationType.BUSINESS_ONLY);
        params.setMaxErrors(100);
        this.validatorFactory = SchematronValidatorFactories.createStaticCompilingValidatorFactory(params);
    }

    public void doValidation(List<InputStream> inputs) {
        for (InputStream is : inputs) {
            SchematronValidator validator = this.validatorFactory.createValidator();
            try {
                validator.validateSubmission(is, new NullOutputStream());
            }
            catch (ValidationException e) {
                e.printStackTrace();
            }
        }
    }
}

