/*
 * Decompiled with CFR 0.152.
 */
package com.gsl.schematron.validator;

import bizrules.binding.DocumentErrorBinding;
import bizrules.binding.DocumentEventBinding;
import com.gsl.docValidator.ValidationParams;
import com.gsl.logging.LoggerFactory;
import com.gsl.sax.xerces.XercesParserMaker;
import com.gsl.schematron.generator.ClassResult;
import com.gsl.schematron.support.ValidatorInitialiser;
import com.gsl.schematron.transformer.SchematronTransformerParams;
import com.gsl.schematron.validator.RuleGeneratorMode;
import com.gsl.schematron.validator.RulesState;
import com.gsl.schematron.validator.SchematronValidatorImpl;
import com.gsl.schematron.validator.api.SchematronValidator;
import com.gsl.schematron.validator.api.SchematronValidatorFactory;
import com.gsl.schematron.validator.api.SchematronValidatorParams;
import com.gsl.schematron.validator.cache.RefreshAwareReader;
import com.gsl.schematron.validator.cache.rules.SchematronRulesStateSource;
import com.gsl.util.classlookup.PackageClassCollector;
import com.gsl.util.classlookup.PropertiesFileClassCollector2;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.logging.Logger;
import validationResponse.output.VersionManifest;

public class SchematronValidatorFactoryImpl
implements SchematronValidatorFactory {
    public static final String VERSION_NUMBER = "1.80";
    private final Object grammarPoolKey = new Object();
    private final SchematronValidatorParams validatorParams;
    private final ValidationParams validationParams;
    private final SchematronRulesStateSource rulesStateSource;
    private final RulesState staticRulesState;
    private RulesState currentRulesState = null;

    private static Logger log() {
        return LoggerFactory.getLogger(SchematronValidatorFactoryImpl.class.getName());
    }

    @Override
    public String getVersionNumber() {
        return VERSION_NUMBER;
    }

    public SchematronValidatorFactoryImpl(SchematronValidatorParams params, RuleGeneratorMode ruleGeneratorMode) {
        this.validatorParams = params.clone();
        this.validationParams = this.validatorParams.createValidationParameters(this.grammarPoolKey);
        LoggerFactory.setLevels(this.validationParams.getLoggingParams().getLogLevels());
        if (ruleGeneratorMode == RuleGeneratorMode.LOAD_FROM_CLASSPATH) {
            this.validatorParams.setExtendedParam("x_generate_classes", "false");
        }
        SchematronTransformerParams transformerParams = new SchematronTransformerParams(this.validatorParams.getExtendedParams());
        transformerParams.setDefaultJavaPackage(this.validatorParams.getGeneratorRootJavaPackage());
        this.rulesStateSource = new SchematronRulesStateSource(this.validatorParams, transformerParams);
        RulesState rulesState = null;
        switch (ruleGeneratorMode) {
            case LOAD_FROM_CLASSPATH: {
                rulesState = this.loadRulesStateFromClasspath();
                break;
            }
            case COMPILE_ONCE: {
                rulesState = this.getLatestRulesState();
                break;
            }
        }
        this.staticRulesState = rulesState;
    }

    @Override
    public SchematronValidator createValidator() {
        this.currentRulesState = this.getRulesState();
        return new SchematronValidatorImpl(this.currentRulesState, this.validationParams);
    }

    @Override
    public VersionManifest getVersionManifest() {
        return this.getRulesState().getVersionManifest();
    }

    private RulesState getRulesState() {
        if (this.staticRulesState != null) {
            return this.staticRulesState;
        }
        return this.getLatestRulesState();
    }

    private RulesState getLatestRulesState() {
        RefreshAwareReader<RulesState> rulesStateReader = this.rulesStateSource.getRulesStateReader();
        RulesState rulesState = rulesStateReader.getTarget();
        if (rulesStateReader.wasTargetRefreshed()) {
            XercesParserMaker.flushGrammarPool(this.grammarPoolKey);
            this.flushClassMetadata();
        }
        return rulesState;
    }

    public void flushClassMetadata() {
        if (this.currentRulesState != null) {
            ClassLoader classloader = this.currentRulesState.getClassResult().getClassLoader();
            DocumentEventBinding.flush(classloader);
            DocumentErrorBinding.flush(classloader);
        }
    }

    protected void finalize() {
        this.flushClassMetadata();
    }

    private RulesState loadRulesStateFromClasspath() {
        try {
            Collection classNames = null;
            if (this.validatorParams.isForceDynamicClassCollection()) {
                classNames = new PackageClassCollector(this.validatorParams.getGeneratorRootJavaPackage()).collectClassNames();
            }
            if (classNames == null || classNames.isEmpty()) {
                classNames = new PropertiesFileClassCollector2(this.validatorParams.getGeneratorRootJavaPackage()).collectClasses();
            }
            if (classNames == null || classNames.isEmpty()) {
                throw new IllegalStateException("no schematron rules found");
            }
            HashSet ruleClasses = new HashSet();
            HashSet initialiserClasses = new HashSet();
            for (String className : classNames) {
                try {
                    Class<?> clazz = Class.forName(className);
                    if (ValidatorInitialiser.class.isAssignableFrom(clazz)) {
                        initialiserClasses.add(clazz);
                        continue;
                    }
                    ruleClasses.add(clazz);
                }
                catch (Exception e) {
                    SchematronValidatorFactoryImpl.log().warning("failed to load schematron rule from classpath: '" + className + "': " + e);
                }
            }
            HashMap namespaceToClassesMap = new HashMap();
            namespaceToClassesMap.put("", ruleClasses);
            namespaceToClassesMap.put("http://gsl.com/schematron-validator/support/intialiser", initialiserClasses);
            ClassResult classResult = new ClassResult(namespaceToClassesMap, SchematronValidatorFactoryImpl.class.getClassLoader());
            RulesState rulesState = this.getLatestRulesState();
            return new RulesState(classResult, rulesState.getEntityResolver(), rulesState.getVersionManifest());
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

