/*
 * Decompiled with CFR 0.152.
 */
package com.gsl.schematron.validator;

import com.gsl.docValidator.DocumentValidator;
import com.gsl.docValidator.DocumentValidatorServices;
import com.gsl.docValidator.PostValidationDelegate;
import com.gsl.docValidator.ValidationException;
import com.gsl.docValidator.ValidationParams;
import com.gsl.docValidator.errorFilters.SchemaLocationErrorFilter;
import com.gsl.sax.decoder.xerces.chris.ChRISXercesExceptionDecoder;
import com.gsl.schematron.support.InvalidValidatorError;
import com.gsl.schematron.support.ValidatorInitialiser;
import com.gsl.schematron.validator.RulesState;
import com.gsl.schematron.validator.SchematronValidatorProvider;
import com.gsl.schematron.validator.api.SchematronValidator;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import processingError.ProcessingError;
import processingError.ProcessingErrorCollector;
import validationResponse.output.ValidationResponseDelegate;
import validationResponse.output.ValidationResult;
import validationResponse.output.ValidationResultInterface;
import validationResponse.output.VersionManifest;
import xmldoc.NamespacePrefixMapper;
import xmldoc.sax.DocumentHandler;
import xmldoc.sax.DocumentHandlerImpl2;
import xmldoc.sax.SAXExceptionDecoder;
import xmldoc.sax.SimpleNamespacePrefixMapper;

public class SchematronValidatorImpl
extends DocumentValidator
implements SchematronValidator {
    private final RulesState rulesState;
    private final ValidationParams params;
    private NamespacePrefixMapper namespacePrefixMapper;

    public SchematronValidatorImpl(RulesState rulesState, ValidationParams params) {
        this.rulesState = rulesState;
        try {
            this.params = (ValidationParams)params.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public ValidationResult validateSubmission(InputStream input, OutputStream output) throws ValidationException {
        com.gsl.docValidator.ValidationResultInterface result;
        this.getController().checkOneShotUse();
        ValidationResponseDelegate delegate = new ValidationResponseDelegate(this.params, output);
        InvalidValidatorError validatorError = this.initialiseValidator(this.params);
        if (validatorError == null) {
            this.getController().addProvider(new SchematronValidatorProvider(this.rulesState));
            result = (ValidationResultInterface)this.getController().validate((DocumentValidator)this, input, this.params, (PostValidationDelegate)delegate);
        } else {
            List<ProcessingError> errors = Collections.singletonList(validatorError);
            result = delegate.createResult((List)errors, this.params);
            result.setProcessingErrors(errors);
        }
        result.setVersionManifest(this.getVersionManifest());
        return result;
    }

    private InvalidValidatorError initialiseValidator(ValidationParams params) {
        try {
            Collection<Class<?>> classes = this.rulesState.getClassResult().getClassesForNamespace("http://gsl.com/schematron-validator/support/intialiser");
            SimpleNamespacePrefixMapper mapper = new SimpleNamespacePrefixMapper();
            for (Class<?> initialiserClass : classes) {
                ValidatorInitialiser initialser = (ValidatorInitialiser)initialiserClass.newInstance();
                InvalidValidatorError error = initialser.initialiseValidator(params);
                if (error != null) {
                    return error;
                }
                mapper.addMappings(initialser.getNamespacePrefixMappings());
            }
            this.namespacePrefixMapper = mapper;
            return null;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    protected DocumentValidatorServices createServices(final ValidationParams params) {
        return new DocumentValidatorServices(params){

            @Override
            protected DocumentHandler createDocumentHandler() {
                DocumentHandlerImpl2 documentHandlerImpl = new DocumentHandlerImpl2(this.getRuleRegistry(), params.getIncludePrefixesInXPaths());
                documentHandlerImpl.setDumpBusinessErrorsOnDocumentError(true);
                if (params.getSuppressSchemaLocationHintErrors()) {
                    documentHandlerImpl.addDocumentErrorFilter(new SchemaLocationErrorFilter());
                }
                return documentHandlerImpl;
            }

            @Override
            protected NamespacePrefixMapper createNamespacePrefixMapper() {
                return SchematronValidatorImpl.this.namespacePrefixMapper;
            }

            @Override
            protected SAXExceptionDecoder createExceptionDecoder() {
                return new ChRISXercesExceptionDecoder();
            }

            @Override
            protected ProcessingErrorCollector createErrorCollector() {
                return super.createErrorCollector();
            }
        };
    }

    @Override
    public VersionManifest getVersionManifest() {
        return this.rulesState.getVersionManifest();
    }

    @Override
    public void setCurrentDate(Date currentDate) {
        this.params.setCurrentDate(currentDate);
    }
}

