/*
 * Decompiled with CFR 0.152.
 */
package com.gsl.schematron.validator;

import bizrules.BusinessRule;
import bizrules.ElementProcessor;
import com.gsl.docValidator.DocumentValidatorImplementor;
import com.gsl.docValidator.ValidationParams;
import com.gsl.docValidator.ValidatorProvider;
import com.gsl.schematron.validator.RulesState;
import java.util.Collection;
import xmldoc.util.EntityResolver;

class SchematronValidatorProvider
implements ValidatorProvider {
    private final RulesState rulesState;
    private boolean provisioned = false;

    SchematronValidatorProvider(RulesState rulesState) {
        this.rulesState = rulesState;
    }

    @Override
    public EntityResolver getEntityResolver(ValidationParams params) {
        return this.rulesState.getEntityResolver();
    }

    @Override
    public void init(DocumentValidatorImplementor validator) {
    }

    @Override
    public void provisionNamespace(String namespace, DocumentValidatorImplementor validator) {
        if (!this.provisioned) {
            this.provisioned = true;
            try {
                Collection<Class<?>> classes = this.rulesState.getClassResult().getAllClasses();
                for (Class<?> clazz : classes) {
                    if (BusinessRule.class.isAssignableFrom(clazz)) {
                        validator.addBusinessRule((BusinessRule)clazz.newInstance());
                        continue;
                    }
                    if (!ElementProcessor.class.isAssignableFrom(clazz)) continue;
                    validator.addElementProcessor((ElementProcessor)clazz.newInstance());
                }
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    @Override
    public void destroy() {
    }
}

