/*
 * Decompiled with CFR 0.152.
 */
package com.gsl.schematron.validator.api;

import com.gsl.docValidator.ValidationException;
import com.gsl.docValidator.ValidationParams;
import com.gsl.docValidator.ValidationResultInterface;
import com.gsl.schematron.validator.api.SchematronValidator;
import com.gsl.schematron.validator.api.SchematronValidatorFactory;
import com.gsl.schematron.validator.api.SchematronValidatorParams;
import com.gsl.util.OneShotUseSupport;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collections;
import java.util.Date;
import validationResponse.output.NullArtefactVersionManifest;
import validationResponse.output.ValidationResponseDelegate;
import validationResponse.output.ValidationResult;
import validationResponse.output.VersionManifest;

class NullValidatorFactory
implements SchematronValidatorFactory {
    private final SchematronValidatorParams params;
    private static final VersionManifest DUMMY_MANIFEST = NullArtefactVersionManifest.instance();

    public NullValidatorFactory(SchematronValidatorParams params) {
        this.params = params.clone();
    }

    @Override
    public SchematronValidator createValidator() {
        return new NullValidator();
    }

    @Override
    public VersionManifest getVersionManifest() {
        return DUMMY_MANIFEST;
    }

    @Override
    public String getVersionNumber() {
        return "null";
    }

    private class NullValidator
    extends OneShotUseSupport
    implements SchematronValidator {
        private NullValidator() {
        }

        @Override
        public ValidationResult validateSubmission(InputStream input, OutputStream output) throws ValidationException {
            this.checkOneShotUse();
            ValidationParams params = NullValidatorFactory.this.params.createValidationParameters(null);
            ValidationResponseDelegate delegate = new ValidationResponseDelegate(params, output);
            ValidationResultInterface result = delegate.createResult(Collections.emptyList(), params);
            result.setVersionManifest(DUMMY_MANIFEST);
            return result;
        }

        @Override
        public VersionManifest getVersionManifest() {
            return DUMMY_MANIFEST;
        }

        @Override
        public boolean interrupt() {
            return false;
        }

        @Override
        public void setCurrentDate(Date currentDate) {
            throw new UnsupportedOperationException("implement me!");
        }
    }
}

