/*
 * Decompiled with CFR 0.152.
 */
package com.gsl.schematron.validator.api;

import com.gsl.schematron.validator.RuleGeneratorMode;
import com.gsl.schematron.validator.SchematronValidatorFactoryImpl;
import com.gsl.schematron.validator.api.SchematronValidatorFactory;
import com.gsl.schematron.validator.api.SchematronValidatorParams;

public final class SchematronValidatorFactories {
    private SchematronValidatorFactories() {
    }

    public static SchematronValidatorFactory createClasspathLoadingValidatorFactory(SchematronValidatorParams params) {
        return SchematronValidatorFactories.createFactoryImpl(params, RuleGeneratorMode.LOAD_FROM_CLASSPATH);
    }

    public static SchematronValidatorFactory createStaticCompilingValidatorFactory(SchematronValidatorParams params) {
        return SchematronValidatorFactories.createFactoryImpl(params, RuleGeneratorMode.COMPILE_ONCE);
    }

    public static SchematronValidatorFactory createDynamicCompilingValidatorFactory(SchematronValidatorParams params) {
        return SchematronValidatorFactories.createFactoryImpl(params, RuleGeneratorMode.RECOMPILE_WHEN_CHANGED);
    }

    private static SchematronValidatorFactoryImpl createFactoryImpl(SchematronValidatorParams params, RuleGeneratorMode ruleGeneratorMode) {
        params.validate();
        return new SchematronValidatorFactoryImpl(params, ruleGeneratorMode);
    }
}

