/*
 * Decompiled with CFR 0.152.
 */
package com.gsl.schematron.validator.api;

import com.gsl.docValidator.ValidationParams;
import com.gsl.schematron.RuleGeneratorParams;
import com.gsl.schematron.validator.api.ValidationType;
import com.gsl.util.PropertiesLoadableSupport;
import com.gsl.util.properties.MutableParamProperties;
import com.gsl.util.properties.ParamProperties;
import java.util.Date;
import java.util.Enumeration;
import java.util.Properties;
import java.util.logging.Level;

public class SchematronValidatorParams
extends PropertiesLoadableSupport
implements RuleGeneratorParams,
Cloneable {
    private static final int DEFAULT_MAX_ERRORS = 100;
    private static final ValidationType DEFAULT_VALIDATION_TYPE = ValidationType.COMPLETE;
    private static final String GENERATOR_ROOT_JAVA_PACKAGE = "schematron._generated_";
    public static final String PROP_VALIDATION_TYPE = "validation_type";
    public static final String PROP_MAX_ERRORS = "max_errors";
    public static final String PROP_SCHEMATRON_FILE_DIRPATH = "schematron_file_dirpath";
    public static final String PROP_SCHEMA_FILE_DIRPATH = "schema_file_dirpath";
    public static final String PROP_TEMPORARY_DIRPATH = "temporary_dirpath";
    public static final String PROP_COMPILER_DEPENDENCY_CLASSPATH = "compiler_dependency_classpath";
    public static final String PROP_FORCE_DYNAMIC_CLASS_COLLECTION = "force_dynamic_class_collection";
    public static final String PROP_OUTPUT_DEVELOPER_MESSAGES = "output_developer_messages";
    public static final String PROP_SOURCE_DIRPATH = "source_dirpath";
    private ValidationType validationType = DEFAULT_VALIDATION_TYPE;
    private int maxErrors = 100;
    private String schematronFileDirpath;
    private String schemaFileDirpath;
    private String temporaryDirpath;
    private String compilerDependencyClasspath = null;
    private boolean includePrefixesInXPaths = true;
    private boolean forceDynamicClassCollection = false;
    private boolean outputDeveloperMessages = true;
    private String sourceDirpath;
    private Level loggingLevel = Level.WARNING;
    private boolean suppressSchemaLocationHintErrors;
    private Date currentDate = null;
    private final MutableParamProperties extendedParams = new MutableParamProperties();

    public ValidationType getValidationType() {
        return this.validationType;
    }

    public void setValidationType(ValidationType validationType) {
        this.validationType = validationType;
    }

    public int getMaxErrors() {
        return this.maxErrors;
    }

    public void setMaxErrors(int maxErrors) {
        this.maxErrors = maxErrors;
    }

    public void setRIMArtefactsDirectory(String RIMArtefactsDirectory) {
        this.setSchemaFileDirpath(RIMArtefactsDirectory);
        this.setSchematronFileDirpath(RIMArtefactsDirectory);
    }

    @Override
    public String getGeneratorRootJavaPackage() {
        return GENERATOR_ROOT_JAVA_PACKAGE;
    }

    @Override
    public String getCompilerDependencyClasspaths() {
        return this.compilerDependencyClasspath;
    }

    public void setCompilerDependencyClasspath(String compilerDependencyClasspath) {
        this.compilerDependencyClasspath = compilerDependencyClasspath;
    }

    @Override
    public String getSchemaFileDirpath() {
        return this.schemaFileDirpath;
    }

    public void setSchemaFileDirpath(String schemaFileDirpath) {
        this.schemaFileDirpath = schemaFileDirpath;
    }

    @Override
    public String getSchematronFileDirpath() {
        return this.schematronFileDirpath;
    }

    public void setSchematronFileDirpath(String schematronFileDirpath) {
        this.schematronFileDirpath = schematronFileDirpath;
    }

    @Override
    public String getTemporaryDirpath() {
        return this.temporaryDirpath;
    }

    public void setTemporaryDirpath(String temporaryDirpath) {
        this.temporaryDirpath = temporaryDirpath;
    }

    @Override
    public boolean isIncludePrefixesInXPaths() {
        return this.includePrefixesInXPaths;
    }

    public void setIncludePrefixesInXPaths(boolean includePrefixesInXPaths) {
        this.includePrefixesInXPaths = includePrefixesInXPaths;
    }

    public boolean isForceDynamicClassCollection() {
        return this.forceDynamicClassCollection;
    }

    public void setForceDynamicClassCollection(boolean forceDynamicClassCollection) {
        this.forceDynamicClassCollection = forceDynamicClassCollection;
    }

    public boolean getOutputDeveloperMessages() {
        return this.outputDeveloperMessages;
    }

    public void setOutputDeveloperMessages(boolean outputDeveloperMessages) {
        this.outputDeveloperMessages = outputDeveloperMessages;
    }

    @Override
    public String getSourceDirpath() {
        return this.sourceDirpath;
    }

    public void setSourceDirpath(String sourceDirpath) {
        this.sourceDirpath = sourceDirpath;
    }

    public ValidationParams createValidationParameters(final Object grammarPoolKey) {
        ValidationParams params = new ValidationParams(){

            @Override
            public Object getVariant() {
                return grammarPoolKey;
            }
        };
        params.setMaxErrors(this.getMaxErrors());
        params.getBizruleParams().setIgnoreBusinessRules(!this.getValidationType().isDoBusinessValidation());
        params.getBizruleParams().setIgnoreBusinessRulesFollowingDocumentError(true);
        params.getBizruleParams().setForceDynamicClassCollection(this.isForceDynamicClassCollection());
        params.getParserParams().setDoSchemaValidation(this.getValidationType().isDoSchemaValidation());
        params.getLoggingParams().setDefaultLevel(this.getLoggingLevel());
        params.setIncludePrefixesInXPaths(this.isIncludePrefixesInXPaths());
        params.setOutputDeveloperMessages(this.getOutputDeveloperMessages());
        params.setReportErrorLimitExceeded(false);
        params.setCurrentDate(this.getCurrentDate());
        params.setSuppressSchemaLocationHintErrors(this.getSuppressSchemaLocationHintErrors());
        return params;
    }

    @Override
    public void load(Properties p) {
        this.setValidationType(ValidationType.valueOf(SchematronValidatorParams.getString(p, PROP_VALIDATION_TYPE, ValidationType.COMPLETE.name()).toUpperCase()));
        this.setMaxErrors((int)SchematronValidatorParams.getInteger(p, PROP_MAX_ERRORS, 100L));
        this.setSchematronFileDirpath(SchematronValidatorParams.getString(p, PROP_SCHEMATRON_FILE_DIRPATH));
        this.setSchemaFileDirpath(SchematronValidatorParams.getString(p, PROP_SCHEMA_FILE_DIRPATH));
        this.setTemporaryDirpath(SchematronValidatorParams.getString(p, PROP_TEMPORARY_DIRPATH));
        this.setCompilerDependencyClasspath(SchematronValidatorParams.getString(p, PROP_COMPILER_DEPENDENCY_CLASSPATH));
        this.setOutputDeveloperMessages(SchematronValidatorParams.getBoolean(p, PROP_OUTPUT_DEVELOPER_MESSAGES, true));
        this.setSourceDirpath(SchematronValidatorParams.getString(p, PROP_SOURCE_DIRPATH));
        Enumeration<Object> e = p.keys();
        while (e.hasMoreElements()) {
            String propertyName = (String)e.nextElement();
            if (!propertyName.startsWith("x_")) continue;
            this.setExtendedParam(propertyName, p.getProperty(propertyName));
        }
    }

    public SchematronValidatorParams clone() {
        try {
            return (SchematronValidatorParams)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new AssertionError((Object)e);
        }
    }

    @Override
    public Level getLoggingLevel() {
        return this.loggingLevel;
    }

    public void setLoggingLevel(Level loggingLevel) {
        this.loggingLevel = loggingLevel;
    }

    void validate() {
        if (this.temporaryDirpath == null) {
            throw new IllegalArgumentException("temp directory not specified");
        }
        if (this.schematronFileDirpath == null) {
            throw new IllegalArgumentException("artifact directory not specified");
        }
        if (this.schemaFileDirpath == null) {
            this.schemaFileDirpath = this.schematronFileDirpath;
        }
    }

    @Override
    public ParamProperties getExtendedParams() {
        return this.extendedParams;
    }

    public void setExtendedParam(String propertyName, String value) {
        if (!propertyName.startsWith("x_")) {
            throw new IllegalArgumentException("extended property name must have 'x_' prefix");
        }
        this.extendedParams.setProperty(propertyName, value);
    }

    public Date getCurrentDate() {
        return this.currentDate;
    }

    public void setCurrentDate(Date currentDate) {
        this.currentDate = currentDate;
    }

    public void setSuppressSchemaLocationHintErrors(boolean suppressSchemaLocationHintErrors) {
        this.suppressSchemaLocationHintErrors = suppressSchemaLocationHintErrors;
    }

    public boolean getSuppressSchemaLocationHintErrors() {
        return this.suppressSchemaLocationHintErrors;
    }
}

