/*
 * Decompiled with CFR 0.152.
 */
package com.gsl.schematron.validator.artefacts;

import com.gsl.sax.xerces.XSDIntrospector;
import com.gsl.schematron.validator.artefacts.Artefact;
import com.gsl.schematron.validator.artefacts.ArtefactNamespace;
import com.gsl.schematron.validator.artefacts.NullNamespace;
import com.gsl.schematron.validator.artefacts.SchemaArtefactNamespace;
import java.io.IOException;
import java.io.InputStream;

public abstract class AbstractArtefact
implements Artefact {
    private ArtefactNamespace namespace = NullNamespace.instance();

    protected void setupNamespace(String fullPath) throws IOException {
        if (fullPath.toLowerCase().endsWith(".xsd")) {
            InputStream inputStream = this.openInputStream();
            XSDIntrospector xsdIntrospector = new XSDIntrospector(inputStream);
            String namespaceStr = xsdIntrospector.getTargetNamespace();
            try {
                inputStream.close();
            }
            catch (IOException e) {
                // empty catch block
            }
            if (fullPath.endsWith("core-v2-0.xsd") && namespaceStr == null) {
                namespaceStr = "http://www.hmrc.gov.uk/schemas/core-v2-0.xsd";
            }
            if (namespaceStr != null) {
                this.namespace = new SchemaArtefactNamespace(namespaceStr);
            }
        }
    }

    @Override
    public String getLocation() {
        return this.getFullName();
    }

    @Override
    public ArtefactNamespace getNamespace() {
        return this.namespace;
    }
}

