/*
 * Decompiled with CFR 0.152.
 */
package com.gsl.schematron.validator.artefacts;

import com.gsl.schematron.validator.artefacts.Artefact;
import com.gsl.schematron.validator.artefacts.ArtefactProcessor;
import com.gsl.schematron.validator.artefacts.ArtefactRepository;
import com.gsl.schematron.validator.artefacts.FullNameArtefactComparator;
import java.io.IOException;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Set;
import java.util.TreeSet;
import java.util.zip.CRC32;

public abstract class AbstractArtefactRepository
implements ArtefactRepository {
    private static final Comparator<Artefact> FULL_NAME_ARTEFACT_COMPARATOR = new FullNameArtefactComparator();
    protected final Set<Artefact> artefacts = new HashSet<Artefact>();
    private long checksum;

    protected void calculateChecksum() throws IOException {
        CRC32 checksum = new CRC32();
        TreeSet<Artefact> sortedArtefacts = new TreeSet<Artefact>(FULL_NAME_ARTEFACT_COMPARATOR);
        sortedArtefacts.addAll(this.artefacts);
        for (Artefact artefact : sortedArtefacts) {
            byte[] bytes = artefact.getFullName().getBytes();
            checksum.update(bytes, 0, bytes.length);
            if (artefact.getLastModifiedDate() == null) continue;
            bytes = String.valueOf(artefact.getLastModifiedDate().getTime()).getBytes();
            checksum.update(bytes, 0, bytes.length);
        }
        this.checksum = checksum.getValue();
    }

    @Override
    public Set<Artefact> getArtefacts() {
        return this.artefacts;
    }

    @Override
    public long getChecksum() {
        return this.checksum;
    }

    @Override
    public void processArtefacts(ArtefactProcessor processor) {
        for (Artefact artefact : this.artefacts) {
            processor.processArtefact(artefact);
        }
    }
}

