/*
 * Decompiled with CFR 0.152.
 */
package com.gsl.schematron.validator.artefacts;

import com.gsl.schematron.validator.artefacts.ArtefactVersion;
import com.gsl.schematron.validator.ruleUnit.RuleUnit;

public abstract class AbstractRuleUnit
implements RuleUnit {
    private final String service;
    private final ArtefactVersion version;

    public AbstractRuleUnit(String service, ArtefactVersion version) {
        this.service = service;
        this.version = version;
    }

    public boolean equals(Object other) {
        boolean result = false;
        if (other.getClass() == this.getClass()) {
            RuleUnit that = (RuleUnit)other;
            result = this.getServiceName().equals(that.getServiceName()) && this.getVersion().equals(that.getVersion());
        }
        return result;
    }

    public int hashCode() {
        return this.getServiceName().hashCode() ^ this.getVersion().hashCode();
    }

    @Override
    public String getServiceName() {
        return this.service;
    }

    @Override
    public ArtefactVersion getVersion() {
        return this.version;
    }

    protected abstract int getComparisonRanking();

    @Override
    public int compareTo(RuleUnit that) {
        int result = this.getServiceName().compareTo(that.getServiceName());
        if (result == 0) {
            int n = result = that instanceof AbstractRuleUnit ? this.getComparisonRanking() - ((AbstractRuleUnit)that).getComparisonRanking() : 0;
        }
        if (result == 0) {
            result = this.getVersion().compareTo(that.getVersion());
        }
        return result;
    }

    @Override
    public String generateJavaPackageName() {
        String variant;
        String servicePackageName = this.getServiceName();
        String year = this.getVersion().getYear();
        if (!year.equals("")) {
            servicePackageName = servicePackageName + "_" + year;
        }
        if (this.getVersion() != null) {
            servicePackageName = servicePackageName + ".v" + this.getVersion().getMajor() + "_" + this.getVersion().getMinor();
        }
        if (!(variant = this.getVersion().getVariant()).equals("")) {
            servicePackageName = servicePackageName + "." + variant;
        }
        return servicePackageName.replace('-', '_');
    }
}

