/*
 * Decompiled with CFR 0.152.
 */
package com.gsl.schematron.validator.artefacts;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ArtefactNameDecoder {
    private static String servicePattern = "([a-zA-Z0-9-]+?)";
    private static String variant_pattern = "([a-zA-Z][a-zA-Z0-9-]+)";
    private static Pattern fileNamePattern = Pattern.compile(servicePattern + "(?:-([0-9]{4}))?-v([0-9]+)-([0-9]+)(?:-([0-9]+))?(?:[-_]" + variant_pattern + ")?(?:\\.[a-zA-Z0-9]+)?\\.(xsd|sch)");
    private static Pattern artefactPackNamePattern = Pattern.compile("HMRC-([a-zA-Z0-9]+)(?:-([a-zA-Z]+))?(?:-([0-9]{4}))?-v([0-9]+)-([0-9]+)(?:-([0-9]+))?(?:[-_]" + variant_pattern + ")?(?:-[0-9]{8})+(\\.zip)?");
    private final String service;
    private final String subService;
    private final String year;
    private final String major;
    private final String minor;
    private final String variant;
    private final String suffix;

    public ArtefactNameDecoder(String name) {
        Matcher fileNameMatcher = fileNamePattern.matcher(name);
        Matcher artefactPackNameMatcher = artefactPackNamePattern.matcher(name);
        if (fileNameMatcher.matches()) {
            this.service = fileNameMatcher.group(1);
            this.subService = "";
            this.year = fileNameMatcher.group(2);
            this.major = fileNameMatcher.group(3);
            this.minor = fileNameMatcher.group(4) + (fileNameMatcher.group(5) != null ? fileNameMatcher.group(5) : "");
            this.variant = fileNameMatcher.group(6);
            this.suffix = fileNameMatcher.group(7);
        } else if (artefactPackNameMatcher.matches()) {
            this.service = artefactPackNameMatcher.group(1);
            this.subService = artefactPackNameMatcher.group(2);
            String yearGroup = artefactPackNameMatcher.group(3);
            this.year = yearGroup != null ? yearGroup : "";
            this.major = artefactPackNameMatcher.group(4);
            this.minor = artefactPackNameMatcher.group(5);
            String variantGroup = artefactPackNameMatcher.group(7);
            this.variant = variantGroup != null ? variantGroup : "";
            this.suffix = "";
        } else {
            throw new IllegalArgumentException("The name '" + name + "' could not be decoded");
        }
    }

    public static Pattern getNamePattern() {
        return fileNamePattern;
    }

    public String getService() {
        return this.service;
    }

    public String getSubService() {
        return this.subService;
    }

    public String getYear() {
        return this.year;
    }

    public String getMajor() {
        return this.major;
    }

    public String getMinor() {
        return this.minor;
    }

    public String getVariant() {
        return this.variant;
    }

    public String getSuffix() {
        return this.suffix;
    }
}

