/*
 * Decompiled with CFR 0.152.
 */
package com.gsl.schematron.validator.artefacts;

import com.gsl.schematron.validator.artefacts.Artefact;
import com.gsl.schematron.validator.artefacts.ArtefactNameDecoder;
import com.gsl.schematron.validator.artefacts.ArtefactVersion;
import java.util.HashSet;
import java.util.Set;

public class ArtefactServiceDecorator {
    private String service = "";
    private ArtefactVersion version = ArtefactVersion.VERSION_ZERO;
    private final Artefact artefact;

    public ArtefactServiceDecorator(Artefact artefact) {
        this.artefact = artefact;
        String name = artefact.getName();
        try {
            String year;
            ArtefactNameDecoder decoder = new ArtefactNameDecoder(name);
            this.service = decoder.getService();
            this.version = new ArtefactVersion(Integer.parseInt(decoder.getMajor()), Integer.parseInt(decoder.getMinor()));
            String variant = decoder.getVariant();
            if (variant != null) {
                this.version.setVariant(variant);
            }
            if ((year = decoder.getYear()) != null) {
                this.version.setYear(year);
            }
        }
        catch (IllegalArgumentException e) {
            int x = name.lastIndexOf(".");
            this.service = x > 0 ? name.substring(0, x) : name;
        }
    }

    public static Set<ArtefactServiceDecorator> decorateArtefacts(Set<Artefact> artefacts) {
        HashSet<ArtefactServiceDecorator> decoratedArtefacts = new HashSet<ArtefactServiceDecorator>();
        for (Artefact artefact : artefacts) {
            decoratedArtefacts.add(new ArtefactServiceDecorator(artefact));
        }
        return decoratedArtefacts;
    }

    public Artefact getArtefact() {
        return this.artefact;
    }

    public String getService() {
        return this.service;
    }

    public ArtefactVersion getVersion() {
        return this.version;
    }
}

