/*
 * Decompiled with CFR 0.152.
 */
package com.gsl.schematron.validator.artefacts;

public class ArtefactVersion
implements Comparable<ArtefactVersion> {
    public static final ArtefactVersion VERSION_ZERO = new ArtefactVersion(0, 0);
    private final int major;
    private final int minor;
    private String variant = "";
    private String year = "";

    public ArtefactVersion(int major, int minor) {
        this.major = major;
        this.minor = minor;
    }

    public String toString() {
        return "" + this.major + "." + this.minor + this.variant + ("".equals(this.year) ? "" : "-" + this.year);
    }

    @Override
    public int compareTo(ArtefactVersion that) {
        int result = 0;
        if (this.major > that.major) {
            result = 1;
        } else if (this.major < that.major) {
            result = -1;
        } else if (this.minor > that.minor) {
            result = 1;
        } else if (this.minor < that.minor) {
            result = -1;
        }
        if (result == 0) {
            result = this.variant.compareTo(that.variant);
        }
        if (result == 0 && !"".equals(this.year) && !"".equals(that.year)) {
            result = this.year.compareTo(that.year);
        }
        return result;
    }

    public boolean equals(Object other) {
        boolean result = false;
        if (other != null && this.getClass() == other.getClass()) {
            result = this.compareTo((ArtefactVersion)other) == 0;
        }
        return result;
    }

    public int getMajor() {
        return this.major;
    }

    public int getMinor() {
        return this.minor;
    }

    public int hashCode() {
        return this.major ^ this.minor ^ this.variant.hashCode();
    }

    public String getVariant() {
        return this.variant;
    }

    public void setVariant(String variant) {
        this.variant = variant;
    }

    public String getYear() {
        return this.year;
    }

    public void setYear(String year) {
        this.year = year;
    }
}

