/*
 * Decompiled with CFR 0.152.
 */
package com.gsl.schematron.validator.artefacts;

import com.gsl.schematron.validator.artefacts.Artefact;
import com.gsl.util.HashCode;
import java.io.File;
import java.text.SimpleDateFormat;
import java.util.Comparator;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import validationResponse.output.ArtefactVersionDescriptor;
import validationResponse.output.VersionManifest;

public class DirSearchFullNameVersionManifest
implements VersionManifest {
    private static final String LAST_MODIFIED_DATE_FORMAT = "yyyy-MM-dd HH:mm:ss z";
    private static final Comparator<ArtefactVersionDescriptor> ARTEFACT_VERSION_DESCRIPTOR_COMPARATOR = ArtefactVersionDescriptor.getComparator(0, 0);
    private final String searchPaths;
    private final SortedSet<ArtefactVersionDescriptor> versionDescriptors;
    private final int hashCode;

    public DirSearchFullNameVersionManifest(Set<File> dirsSearched, Set<Artefact> artefacts) {
        this.searchPaths = this.sortAndConcatenateDirs(dirsSearched);
        this.versionDescriptors = new TreeSet<ArtefactVersionDescriptor>(ARTEFACT_VERSION_DESCRIPTOR_COMPARATOR);
        for (Artefact artefact : artefacts) {
            ArtefactVersionDescriptor versionDescriptor = new ArtefactVersionDescriptor(artefact.getFullName(), artefact.getLastModifiedDate());
            this.versionDescriptors.add(versionDescriptor);
        }
        this.hashCode = this.calculateHashCode();
    }

    @Override
    public String getSearchPaths() {
        return this.searchPaths;
    }

    @Override
    public Set<ArtefactVersionDescriptor> getVersionDescriptors() {
        return this.versionDescriptors;
    }

    private int calculateHashCode() {
        int result = 23;
        result = HashCode.hash(result, this.searchPaths);
        result = HashCode.hash(result, this.versionDescriptors);
        return result;
    }

    public int hashCode() {
        return this.hashCode;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o == null || !VersionManifest.class.isAssignableFrom(o.getClass())) {
            return false;
        }
        VersionManifest other = (VersionManifest)o;
        return this.searchPaths.equals(other.getSearchPaths()) && this.versionDescriptors.equals(other.getVersionDescriptors());
    }

    public String toString() {
        return "[ " + this.concatenateVersionDescriptors(this.versionDescriptors) + " ]";
    }

    private String sortAndConcatenateDirs(Set<File> dirs) {
        TreeSet<String> dirpaths = new TreeSet<String>();
        for (File dir : dirs) {
            String dirpath = dir.getPath();
            dirpaths.add(dirpath);
        }
        StringBuilder builder = new StringBuilder();
        String joiner = "";
        for (String dirpath : dirpaths) {
            builder.append(joiner + dirpath);
            joiner = " " + File.pathSeparator + " ";
        }
        return builder.toString();
    }

    private String concatenateVersionDescriptors(SortedSet<ArtefactVersionDescriptor> versionDescriptors) {
        SimpleDateFormat lastModifiedDateFormatter = new SimpleDateFormat(LAST_MODIFIED_DATE_FORMAT);
        StringBuilder builder = new StringBuilder();
        String joiner = "";
        for (ArtefactVersionDescriptor avd : versionDescriptors) {
            builder.append(joiner + avd.getFullName());
            if (avd.getLastModifiedDate() != null) {
                builder.append(" (" + lastModifiedDateFormatter.format(avd.getLastModifiedDate()) + ")");
            }
            joiner = " " + File.pathSeparator + " ";
        }
        return builder.toString();
    }
}

