/*
 * Decompiled with CFR 0.152.
 */
package com.gsl.schematron.validator.artefacts;

import com.gsl.schematron.validator.artefacts.AbstractArtefactRepository;
import com.gsl.schematron.validator.artefacts.FileArtefactFilter;
import com.gsl.schematron.validator.artefacts.ZipFileEntryArtefact;
import java.io.IOException;
import java.util.Enumeration;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public class FileArchiveArtefactRepository
extends AbstractArtefactRepository {
    public FileArchiveArtefactRepository(ZipFile archiveToSearch) throws IOException {
        this.populateMatchingArtefactEntries(archiveToSearch);
    }

    private void populateMatchingArtefactEntries(ZipFile archive) throws IOException {
        Enumeration<? extends ZipEntry> entries = archive.entries();
        while (entries.hasMoreElements()) {
            ZipEntry entry = entries.nextElement();
            if (!FileArtefactFilter.instance().accept(null, entry.getName())) continue;
            ZipFileEntryArtefact artefact = new ZipFileEntryArtefact(archive.getName(), entry.getName());
            this.artefacts.add(artefact);
        }
    }
}

